/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.PyTorchLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.TensorFlowLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.pytorch.component.PyTorchWorkerComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.component.TensorFlowWorkerComponent;

public class WorkerComponentFactory {
    private final FileSystemOperations fsOperations;
    private final RemoteDirectoryManager remoteDirectoryManager;
    private final RunJobParameters parameters;
    private final LaunchCommandFactory launchCommandFactory;
    private final Configuration yarnConfig;

    WorkerComponentFactory(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters, LaunchCommandFactory launchCommandFactory, Configuration yarnConfig) {
        this.fsOperations = fsOperations;
        this.remoteDirectoryManager = remoteDirectoryManager;
        this.parameters = parameters;
        this.launchCommandFactory = launchCommandFactory;
        this.yarnConfig = yarnConfig;
    }

    public AbstractComponent create(Framework framework, Role role) {
        if (framework == Framework.TENSORFLOW) {
            return new TensorFlowWorkerComponent(this.fsOperations, this.remoteDirectoryManager, (TensorFlowRunJobParameters)this.parameters, role, (TensorFlowLaunchCommandFactory)this.launchCommandFactory, this.yarnConfig);
        }
        if (framework == Framework.PYTORCH) {
            return new PyTorchWorkerComponent(this.fsOperations, this.remoteDirectoryManager, (PyTorchRunJobParameters)this.parameters, role, (PyTorchLaunchCommandFactory)this.launchCommandFactory, this.yarnConfig);
        }
        throw new UnsupportedOperationException("Only supported frameworks are: " + Framework.getValues());
    }
}

