/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractComponent;

public class ServiceWrapper {
    private final Service service;
    @VisibleForTesting
    private Map<String, String> componentToLocalLaunchCommand = Maps.newHashMap();

    public ServiceWrapper(Service service) {
        this.service = service;
    }

    public void addComponent(AbstractComponent abstractComponent) throws IOException {
        Component component = abstractComponent.createComponent();
        this.service.addComponent(component);
        this.storeComponentName(abstractComponent, component.getName());
    }

    private void storeComponentName(AbstractComponent component, String name) {
        this.componentToLocalLaunchCommand.put(name, component.getLocalScriptFile());
    }

    public Service getService() {
        return this.service;
    }

    public String getLocalLaunchCommandPathForComponent(String componentName) {
        return this.componentToLocalLaunchCommand.get(componentName);
    }
}

