/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.utils.ClassPathUtilities;
import org.apache.hadoop.yarn.submarine.utils.EnvironmentUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopEnvironmentSetup {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopEnvironmentSetup.class);
    private static final String CORE_SITE_XML = "core-site.xml";
    private static final String HDFS_SITE_XML = "hdfs-site.xml";
    public static final String DOCKER_HADOOP_HDFS_HOME = "DOCKER_HADOOP_HDFS_HOME";
    public static final String DOCKER_JAVA_HOME = "DOCKER_JAVA_HOME";
    private final RemoteDirectoryManager remoteDirectoryManager;
    private final FileSystemOperations fsOperations;

    public HadoopEnvironmentSetup(ClientContext clientContext, FileSystemOperations fsOperations) {
        this.remoteDirectoryManager = clientContext.getRemoteDirectoryManager();
        this.fsOperations = fsOperations;
    }

    public void addHdfsClassPath(RunJobParameters parameters, PrintWriter fw, Component comp) throws IOException {
        String hdfsHome = null;
        String javaHome = null;
        boolean hadoopEnv = false;
        for (String envVar : parameters.getEnvars()) {
            if (envVar.startsWith("DOCKER_HADOOP_HDFS_HOME=")) {
                hdfsHome = EnvironmentUtilities.getValueOfEnvironment(envVar);
                hadoopEnv = true;
                continue;
            }
            if (!envVar.startsWith("DOCKER_JAVA_HOME=")) continue;
            javaHome = EnvironmentUtilities.getValueOfEnvironment(envVar);
        }
        boolean hasHdfsEnvs = hdfsHome != null && javaHome != null;
        boolean needHdfs = this.doesNeedHdfs(parameters, hadoopEnv);
        if (needHdfs) {
            if (hdfsHome != null) {
                this.appendHdfsHome(fw, hdfsHome);
            }
            fw.append("export HADOOP_CONF_DIR=$WORK_DIR\n");
            if (javaHome != null) {
                this.appendJavaHome(fw, javaHome);
            }
            fw.append("export CLASSPATH=`$HADOOP_HDFS_HOME/bin/hadoop classpath --glob`\n");
        }
        if (needHdfs && !hasHdfsEnvs) {
            LOG.error("When HDFS is being used to read/write models/data, the following environment variables are required: 1) {}=<HDFS_HOME inside docker container> 2) {}=<JAVA_HOME inside docker container>. You can use --env to pass these environment variables.", (Object)DOCKER_HADOOP_HDFS_HOME, (Object)DOCKER_JAVA_HOME);
            throw new IOException("Failed to detect HDFS-related environments.");
        }
        Path stagingDir = this.remoteDirectoryManager.getJobStagingArea(parameters.getName(), true);
        File coreSite = ClassPathUtilities.findFileOnClassPath(CORE_SITE_XML);
        File hdfsSite = ClassPathUtilities.findFileOnClassPath(HDFS_SITE_XML);
        if (coreSite == null || hdfsSite == null) {
            LOG.error("HDFS is being used, however we could not locate {} nor {} on classpath! Please double check your classpath setting and make sure these setting files are included!", (Object)CORE_SITE_XML, (Object)HDFS_SITE_XML);
            throw new IOException("Failed to locate core-site.xml / hdfs-site.xml on classpath!");
        }
        this.fsOperations.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, coreSite.getAbsolutePath(), CORE_SITE_XML, comp);
        this.fsOperations.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, hdfsSite.getAbsolutePath(), HDFS_SITE_XML, comp);
        if (SubmarineLogs.isVerbose()) {
            this.appendEchoOfEnvVars(fw);
        }
    }

    private boolean doesNeedHdfs(RunJobParameters parameters, boolean hadoopEnv) {
        ImmutableList stringsToCheck;
        List launchCommands = parameters.getLaunchCommands();
        if (launchCommands != null) {
            launchCommands.removeIf(Objects::isNull);
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (launchCommands != null && !launchCommands.isEmpty()) {
            listBuilder.addAll((Iterable)launchCommands);
        }
        if (parameters.getInputPath() != null) {
            listBuilder.add((Object)parameters.getInputPath());
        }
        return FileSystemOperations.needHdfs((List<String>)(stringsToCheck = listBuilder.build())) || hadoopEnv;
    }

    private void appendHdfsHome(PrintWriter fw, String hdfsHome) {
        fw.append("export HADOOP_HOME=\n");
        fw.append("export HADOOP_YARN_HOME=\n");
        fw.append("export HADOOP_HDFS_HOME=" + hdfsHome + "\n");
        fw.append("export HADOOP_COMMON_HOME=" + hdfsHome + "\n");
    }

    private void appendJavaHome(PrintWriter fw, String javaHome) {
        fw.append("export JAVA_HOME=" + javaHome + "\n");
        fw.append("export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$JAVA_HOME/lib/amd64/server\n");
    }

    private void appendEchoOfEnvVars(PrintWriter fw) {
        fw.append("echo \"CLASSPATH:$CLASSPATH\"\n");
        fw.append("echo \"HADOOP_CONF_DIR:$HADOOP_CONF_DIR\"\n");
        fw.append("echo \"HADOOP_TOKEN_FILE_LOCATION:$HADOOP_TOKEN_FILE_LOCATION\"\n");
        fw.append("echo \"JAVA_HOME:$JAVA_HOME\"\n");
        fw.append("echo \"LD_LIBRARY_PATH:$LD_LIBRARY_PATH\"\n");
        fw.append("echo \"HADOOP_HDFS_HOME:$HADOOP_HDFS_HOME\"\n");
    }
}

