/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.utils.ZipUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemOperations {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemOperations.class);
    private final Configuration submarineConfig;
    private final Configuration yarnConfig;
    private Set<Path> uploadedFiles = new HashSet<Path>();
    private RemoteDirectoryManager remoteDirectoryManager;

    public FileSystemOperations(ClientContext clientContext) {
        this.remoteDirectoryManager = clientContext.getRemoteDirectoryManager();
        this.submarineConfig = clientContext.getSubmarineConfig();
        this.yarnConfig = clientContext.getYarnConfig();
    }

    public String downloadAndZip(String remoteDir, String zipFileName, boolean doZip) throws IOException {
        String suffix;
        String srcDir = remoteDir;
        String zipDirPath = System.getProperty("java.io.tmpdir") + "/" + zipFileName;
        boolean needDeleteTempDir = false;
        if (this.remoteDirectoryManager.isRemote(remoteDir)) {
            FileStatus status = this.remoteDirectoryManager.getRemoteFileStatus(new Path(remoteDir));
            suffix = "_" + status.getModificationTime() + "-" + this.remoteDirectoryManager.getRemoteFileSize(remoteDir);
            boolean downloaded = this.remoteDirectoryManager.copyRemoteToLocal(remoteDir, zipDirPath);
            if (!downloaded) {
                throw new IOException("Failed to download files from " + remoteDir);
            }
            LOG.info("Downloaded remote: {} to local: {}", (Object)remoteDir, (Object)zipDirPath);
            srcDir = zipDirPath;
            needDeleteTempDir = true;
        } else {
            File localDir = new File(remoteDir);
            suffix = "_" + localDir.lastModified() + "-" + localDir.length();
        }
        if (!doZip) {
            return srcDir;
        }
        String zipFileUri = ZipUtilities.zipDir(srcDir, zipDirPath + suffix + ".zip");
        if (needDeleteTempDir) {
            this.deleteFiles(srcDir);
        }
        return zipFileUri;
    }

    public void deleteFiles(String localUri) {
        boolean success = FileUtil.fullyDelete((File)new File(localUri));
        if (!success) {
            LOG.warn("Failed to delete {}", (Object)localUri);
        }
        LOG.info("Deleted {}", (Object)localUri);
    }

    @VisibleForTesting
    public void uploadToRemoteFileAndLocalizeToContainerWorkDir(Path stagingDir, String fileToUpload, String destFilename, Component comp) throws IOException {
        Path uploadedFilePath = this.uploadToRemoteFile(stagingDir, fileToUpload);
        this.locateRemoteFileToContainerWorkDir(destFilename, comp, uploadedFilePath);
    }

    private void locateRemoteFileToContainerWorkDir(String destFilename, Component comp, Path uploadedFilePath) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.yarnConfig);
        FileStatus fileStatus = fs.getFileStatus(uploadedFilePath);
        LOG.info("Uploaded file path = " + fileStatus.getPath());
        comp.getConfiguration().getFiles().add(new ConfigFile().srcFile(fileStatus.getPath().toUri().toString()).destFile(destFilename).type(ConfigFile.TypeEnum.STATIC));
    }

    public Path uploadToRemoteFile(Path stagingDir, String fileToUpload) throws IOException {
        FileSystem fs = this.remoteDirectoryManager.getDefaultFileSystem();
        File localFile = new File(fileToUpload);
        if (!localFile.exists()) {
            throw new FileNotFoundException("Trying to upload file=" + localFile.getAbsolutePath() + " to remote, but couldn't find local file.");
        }
        String filename = new File(fileToUpload).getName();
        Path uploadedFilePath = new Path(stagingDir, filename);
        if (!this.uploadedFiles.contains(uploadedFilePath)) {
            if (SubmarineLogs.isVerbose()) {
                LOG.info("Copying local file=" + fileToUpload + " to remote=" + uploadedFilePath);
            }
            fs.copyFromLocalFile(new Path(fileToUpload), uploadedFilePath);
            this.uploadedFiles.add(uploadedFilePath);
        }
        return uploadedFilePath;
    }

    public void validFileSize(String uri) throws IOException {
        long actualSizeByte;
        String locationType = "Local";
        if (this.remoteDirectoryManager.isRemote(uri)) {
            actualSizeByte = this.remoteDirectoryManager.getRemoteFileSize(uri);
            locationType = "Remote";
        } else {
            actualSizeByte = FileUtil.getDU((File)new File(uri));
        }
        long maxFileSizeMB = this.submarineConfig.getLong("submarine.localization.max-allowed-file-size-mb", 2048L);
        LOG.info("{} fie/dir: {}, size(Byte):{}, Allowed max file/dir size: {}", new Object[]{locationType, uri, actualSizeByte, maxFileSizeMB * 1024L * 1024L});
        if (actualSizeByte > maxFileSizeMB * 1024L * 1024L) {
            throw new IOException(uri + " size(Byte): " + actualSizeByte + " exceeds configured max size:" + maxFileSizeMB * 1024L * 1024L);
        }
    }

    public void setPermission(Path destPath, FsPermission permission) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.yarnConfig);
        fs.setPermission(destPath, new FsPermission(permission));
    }

    public static boolean needHdfs(List<String> stringsToCheck) {
        for (String content : stringsToCheck) {
            if (content == null || !content.contains("hdfs://")) continue;
            return true;
        }
        return false;
    }

    public static boolean needHdfs(String content) {
        return content != null && content.contains("hdfs://");
    }
}

