/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.submarine.client.cli.param.Quicklink;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.api.PyTorchRole;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.ServiceSpec;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.ServiceWrapper;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.WorkerComponentFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceUtils;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.TensorFlowCommons;
import org.apache.hadoop.yarn.submarine.utils.DockerUtilities;
import org.apache.hadoop.yarn.submarine.utils.EnvironmentUtilities;
import org.apache.hadoop.yarn.submarine.utils.KerberosPrincipalFactory;
import org.apache.hadoop.yarn.submarine.utils.Localizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceSpec
implements ServiceSpec {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceSpec.class);
    protected final RunJobParameters parameters;
    protected final FileSystemOperations fsOperations;
    private final Localizer localizer;
    protected final RemoteDirectoryManager remoteDirectoryManager;
    protected final Configuration yarnConfig;
    protected final LaunchCommandFactory launchCommandFactory;
    private final WorkerComponentFactory workerFactory;

    public AbstractServiceSpec(RunJobParameters parameters, ClientContext clientContext, FileSystemOperations fsOperations, LaunchCommandFactory launchCommandFactory, Localizer localizer) {
        this.parameters = parameters;
        this.remoteDirectoryManager = clientContext.getRemoteDirectoryManager();
        this.yarnConfig = clientContext.getYarnConfig();
        this.fsOperations = fsOperations;
        this.localizer = localizer;
        this.launchCommandFactory = launchCommandFactory;
        this.workerFactory = new WorkerComponentFactory(fsOperations, this.remoteDirectoryManager, parameters, launchCommandFactory, this.yarnConfig);
    }

    protected ServiceWrapper createServiceSpecWrapper() throws IOException {
        Service serviceSpec = new Service();
        serviceSpec.setName(this.parameters.getName());
        serviceSpec.setVersion(String.valueOf(System.currentTimeMillis()));
        serviceSpec.setArtifact(DockerUtilities.getDockerArtifact(this.parameters.getDockerImageName()));
        KerberosPrincipal kerberosPrincipal = KerberosPrincipalFactory.create(this.fsOperations, this.remoteDirectoryManager, this.parameters);
        if (kerberosPrincipal != null) {
            serviceSpec.setKerberosPrincipal(kerberosPrincipal);
        }
        EnvironmentUtilities.handleServiceEnvs(serviceSpec, this.yarnConfig, this.parameters.getEnvars());
        this.localizer.handleLocalizations(serviceSpec);
        return new ServiceWrapper(serviceSpec);
    }

    protected void addWorkerComponents(ServiceWrapper serviceWrapper, Framework framework) throws IOException {
        TensorFlowRole workerRole;
        TensorFlowRole primaryWorkerRole;
        if (framework == Framework.TENSORFLOW) {
            primaryWorkerRole = TensorFlowRole.PRIMARY_WORKER;
            workerRole = TensorFlowRole.WORKER;
        } else {
            primaryWorkerRole = PyTorchRole.PRIMARY_WORKER;
            workerRole = PyTorchRole.WORKER;
        }
        this.addWorkerComponent(serviceWrapper, (Role)primaryWorkerRole, framework);
        if (this.parameters.getNumWorkers() > 1) {
            this.addWorkerComponent(serviceWrapper, (Role)workerRole, framework);
        }
    }

    private void addWorkerComponent(ServiceWrapper serviceWrapper, Role role, Framework framework) throws IOException {
        AbstractComponent component = this.workerFactory.create(framework, role);
        serviceWrapper.addComponent(component);
    }

    protected void handleQuicklinks(Service serviceSpec) throws IOException {
        List quicklinks = this.parameters.getQuicklinks();
        if (quicklinks != null && !quicklinks.isEmpty()) {
            for (Quicklink ql : quicklinks) {
                String instanceName = ql.getComponentInstanceName();
                boolean found = false;
                block1: for (Component comp : serviceSpec.getComponents()) {
                    int i = 0;
                    while ((long)i < comp.getNumberOfContainers()) {
                        String possibleInstanceName = comp.getName() + "-" + i;
                        if (possibleInstanceName.equals(instanceName)) {
                            found = true;
                            continue block1;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    throw new IOException("Couldn't find a component instance = " + instanceName + " while adding quicklink");
                }
                String link = ql.getProtocol() + YarnServiceUtils.getDNSName(serviceSpec.getName(), instanceName, TensorFlowCommons.getUserName(), TensorFlowCommons.getDNSDomain(this.yarnConfig), ql.getPort());
                AbstractServiceSpec.addQuicklink(serviceSpec, ql.getLabel(), link);
            }
        }
    }

    protected static void addQuicklink(Service serviceSpec, String label, String link) {
        HashMap<String, String> quicklinks = serviceSpec.getQuicklinks();
        if (quicklinks == null) {
            quicklinks = new HashMap<String, String>();
            serviceSpec.setQuicklinks(quicklinks);
        }
        if (SubmarineLogs.isVerbose()) {
            LOG.info("Added quicklink, " + label + "=" + link);
        }
        quicklinks.put(label, link);
    }
}

