/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.PyTorchRole;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.AbstractLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.TensorFlowCommons;
import org.apache.hadoop.yarn.submarine.utils.DockerUtilities;
import org.apache.hadoop.yarn.submarine.utils.SubmarineResourceUtils;

public abstract class AbstractComponent {
    private final FileSystemOperations fsOperations;
    protected final RunJobParameters parameters;
    protected final Role role;
    private final RemoteDirectoryManager remoteDirectoryManager;
    protected final Configuration yarnConfig;
    private final LaunchCommandFactory launchCommandFactory;
    private String localScriptFile;

    public AbstractComponent(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters, Role role, Configuration yarnConfig, LaunchCommandFactory launchCommandFactory) {
        this.fsOperations = fsOperations;
        this.remoteDirectoryManager = remoteDirectoryManager;
        this.parameters = parameters;
        this.role = role;
        this.launchCommandFactory = launchCommandFactory;
        this.yarnConfig = yarnConfig;
    }

    protected abstract Component createComponent() throws IOException;

    protected Component createComponentInternal() throws IOException {
        Objects.requireNonNull(this.parameters.getWorkerResource(), "Worker resource must not be null!");
        if (this.parameters.getNumWorkers() < 1) {
            throw new IllegalArgumentException("Number of workers should be at least 1!");
        }
        Component component = new Component();
        component.setName(this.role.getComponentName());
        if (this.role.equals(TensorFlowRole.PRIMARY_WORKER) || this.role.equals(PyTorchRole.PRIMARY_WORKER)) {
            component.setNumberOfContainers(Long.valueOf(1L));
            component.getConfiguration().setProperty("yarn.service.container-state-report-as-service-state", "true");
        } else {
            component.setNumberOfContainers(Long.valueOf((long)this.parameters.getNumWorkers() - 1L));
        }
        if (this.parameters.getWorkerDockerImage() != null) {
            component.setArtifact(DockerUtilities.getDockerArtifact(this.parameters.getWorkerDockerImage()));
        }
        component.setResource(SubmarineResourceUtils.convertYarnResourceToServiceResource(this.parameters.getWorkerResource()));
        component.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
        TensorFlowCommons.addCommonEnvironments(component, this.role);
        this.generateLaunchCommand(component);
        return component;
    }

    protected void generateLaunchCommand(Component component) throws IOException {
        AbstractLaunchCommand launchCommand = this.launchCommandFactory.createLaunchCommand(this.role, component);
        this.localScriptFile = launchCommand.generateLaunchScript();
        String remoteLaunchCommand = this.uploadLaunchCommand(component);
        component.setLaunchCommand(remoteLaunchCommand);
    }

    private String uploadLaunchCommand(Component component) throws IOException {
        Objects.requireNonNull(this.localScriptFile, "localScriptFile should be set before calling this method!");
        Path stagingDir = this.remoteDirectoryManager.getJobStagingArea(this.parameters.getName(), true);
        String destScriptFileName = TensorFlowCommons.getScriptFileName(this.role);
        this.fsOperations.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, this.localScriptFile, destScriptFileName, component);
        return "./" + destScriptFileName;
    }

    String getLocalScriptFile() {
        return this.localScriptFile;
    }
}

