/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.tony.buider;

import com.linkedin.tony.rpc.TaskInfo;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.submarine.common.api.JobComponentStatus;
import org.apache.hadoop.yarn.submarine.common.api.JobStatus;

public final class JobStatusBuilder {
    public static JobStatus fromTaskInfoSet(Set<TaskInfo> taskInfos) {
        JobStatus status = new JobStatus();
        Set jobNames = taskInfos.stream().map(TaskInfo::getName).collect(Collectors.toSet());
        ArrayList<JobComponentStatus> jobComponentStatusList = new ArrayList<JobComponentStatus>();
        for (String jobName : jobNames) {
            Set filterTasks = taskInfos.stream().filter(taskInfo -> taskInfo.getName().equals(jobName)).collect(Collectors.toSet());
            long numReadyContainers = 0L;
            long numRunningContainers = 0L;
            long totalAskedContainers = 0L;
            for (TaskInfo taskInfo2 : filterTasks) {
                ++totalAskedContainers;
                switch (taskInfo2.getStatus()) {
                    case READY: {
                        ++numReadyContainers;
                        break;
                    }
                    case RUNNING: {
                        ++numRunningContainers;
                        break;
                    }
                }
            }
            jobComponentStatusList.add(new JobComponentStatus(jobName, numReadyContainers, numRunningContainers, totalAskedContainers));
        }
        status.setComponentStatus(jobComponentStatusList);
        return status;
    }

    private JobStatusBuilder() {
    }
}

