/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.tony;

import com.linkedin.tony.TonyConfigurationKeys;
import com.linkedin.tony.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.resource.ResourceUtils;

public final class TonyUtils {
    private static final Log LOG = LogFactory.getLog(TonyUtils.class);

    public static Configuration tonyConfFromClientContext(TensorFlowRunJobParameters parameters) {
        Configuration tonyConf = new Configuration();
        tonyConf.setInt(TonyConfigurationKeys.getInstancesKey((String)"worker"), parameters.getNumWorkers());
        tonyConf.setInt(TonyConfigurationKeys.getInstancesKey((String)"ps"), parameters.getNumPS());
        if (parameters.getPsResource() != null) {
            tonyConf.setInt(TonyConfigurationKeys.getResourceKey((String)"ps", (String)"vcores"), parameters.getPsResource().getVirtualCores());
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"ps", (String)"memory"), ResourceUtils.getMemorySize((Resource)parameters.getPsResource()));
        }
        if (parameters.getWorkerResource() != null) {
            tonyConf.setInt(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"vcores"), parameters.getWorkerResource().getVirtualCores());
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"memory"), ResourceUtils.getMemorySize((Resource)parameters.getWorkerResource()));
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"gpus"), ResourceUtils.getResourceValue((Resource)parameters.getWorkerResource(), (String)"yarn.io/gpu"));
        }
        if (parameters.getQueue() != null) {
            tonyConf.set("tony.yarn.queue", parameters.getQueue());
        }
        if (parameters.getDockerImageName() != null) {
            tonyConf.set(TonyConfigurationKeys.getContainerDockerKey(), parameters.getDockerImageName());
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
        if (parameters.getWorkerDockerImage() != null) {
            tonyConf.set(TonyConfigurationKeys.getDockerImageKey((String)"worker"), parameters.getWorkerDockerImage());
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
        if (parameters.getPsDockerImage() != null) {
            tonyConf.set(TonyConfigurationKeys.getDockerImageKey((String)"ps"), parameters.getPsDockerImage());
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
        List envs = parameters.getEnvars();
        tonyConf.setStrings("tony.containers.envs", envs.toArray(new String[0]));
        tonyConf.setStrings("tony.execution.envs", (String[])envs.stream().map(env -> env.replaceAll("DOCKER_", "")).toArray(String[]::new));
        tonyConf.setStrings("tony.containers.envs", (String[])envs.stream().map(env -> env.replaceAll("DOCKER_", "")).toArray(String[]::new));
        if (parameters.getWorkerLaunchCmd() != null) {
            tonyConf.set(TonyConfigurationKeys.getExecuteCommandKey((String)"worker"), parameters.getWorkerLaunchCmd());
        }
        if (parameters.getPSLaunchCmd() != null) {
            tonyConf.set(TonyConfigurationKeys.getExecuteCommandKey((String)"ps"), parameters.getPSLaunchCmd());
        }
        tonyConf.setBoolean("tony.application.security.enabled", !parameters.isSecurityDisabled());
        if (parameters.getLocalizations() != null) {
            tonyConf.setStrings(TonyConfigurationKeys.getContainerResourcesKey(), (String[])parameters.getLocalizations().stream().map(lo -> lo.getRemoteUri() + "::" + lo.getLocalPath()).toArray(String[]::new));
        }
        if (parameters.getConfPairs() != null) {
            String[] confArray = parameters.getConfPairs().toArray(new String[0]);
            for (Map.Entry cliConf : Utils.parseKeyValue((String[])confArray).entrySet()) {
                String[] existingValue = tonyConf.getStrings((String)cliConf.getKey());
                if (existingValue != null && TonyConfigurationKeys.MULTI_VALUE_CONF.contains(cliConf.getKey())) {
                    ArrayList<String> newValues = new ArrayList<String>(Arrays.asList(existingValue));
                    newValues.add((String)cliConf.getValue());
                    tonyConf.setStrings((String)cliConf.getKey(), newValues.toArray(new String[0]));
                    continue;
                }
                tonyConf.set((String)cliConf.getKey(), (String)cliConf.getValue());
            }
        }
        LOG.info((Object)("Resources: " + tonyConf.get(TonyConfigurationKeys.getContainerResourcesKey())));
        return tonyConf;
    }

    private TonyUtils() {
    }
}

