/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.tony;

import com.linkedin.tony.TonyClient;
import com.linkedin.tony.client.CallbackHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.runtimes.RuntimeFactory;
import org.apache.hadoop.yarn.submarine.runtimes.common.FSBasedSubmarineStorageImpl;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.apache.hadoop.yarn.submarine.runtimes.common.SubmarineStorage;
import org.apache.hadoop.yarn.submarine.runtimes.tony.TonyJobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.tony.TonyJobSubmitter;

public class TonyRuntimeFactory
extends RuntimeFactory {
    private TonyClient tonyClient;
    private TonyJobSubmitter submitter = new TonyJobSubmitter();
    private TonyJobMonitor monitor;

    public TonyRuntimeFactory(ClientContext clientContext) {
        super(clientContext);
        this.tonyClient = new TonyClient((CallbackHandler)this.submitter, new Configuration());
        this.monitor = new TonyJobMonitor(clientContext, this.tonyClient);
        this.submitter.setTonyClient(this.tonyClient);
    }

    protected JobSubmitter internalCreateJobSubmitter() {
        return this.submitter;
    }

    protected JobMonitor internalCreateJobMonitor() {
        return this.monitor;
    }

    protected SubmarineStorage internalCreateSubmarineStorage() {
        return new FSBasedSubmarineStorageImpl(this.clientContext);
    }
}

