/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.tony;

import com.linkedin.tony.TonyClient;
import com.linkedin.tony.client.CallbackHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.apache.hadoop.yarn.submarine.runtimes.tony.TonyUtils;

public class TonyJobSubmitter
implements JobSubmitter,
CallbackHandler {
    private static final Log LOG = LogFactory.getLog(TonyJobSubmitter.class);
    private ApplicationId applicationId;
    private TonyClient tonyClient;

    public void setTonyClient(TonyClient client) {
        this.tonyClient = client;
    }

    public ApplicationId submitJob(ParametersHolder parameters) throws IOException {
        if (parameters.getFramework() == Framework.PYTORCH) {
            throw new UnsupportedOperationException("Support \"\u2013-framework\" option for PyTorch in Tony is coming. Please check the documentation about how to submit a PyTorch job with TonY runtime.");
        }
        LOG.info((Object)"Starting Tony runtime..");
        File tonyFinalConfPath = File.createTempFile("temp", "tony-final.xml");
        Configuration tonyConf = TonyUtils.tonyConfFromClientContext((TensorFlowRunJobParameters)parameters.getParameters());
        try (FileOutputStream os = new FileOutputStream(tonyFinalConfPath);){
            tonyConf.writeXml((OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create " + tonyFinalConfPath + " conf file. Exiting.", e);
        }
        try {
            this.tonyClient.init(new String[]{"--conf_file", tonyFinalConfPath.getAbsolutePath()});
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init TonyClient: ", (Throwable)e);
        }
        Thread clientThread = new Thread(() -> ((TonyClient)this.tonyClient).start());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.tonyClient.forceKillApplication();
            }
            catch (IOException | YarnException e) {
                LOG.error((Object)"Failed to kill application during shutdown.", e);
            }
        }));
        clientThread.start();
        while (clientThread.isAlive()) {
            if (this.applicationId != null) {
                LOG.info((Object)("TonyClient returned applicationId: " + this.applicationId));
                return this.applicationId;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public void onApplicationIdReceived(ApplicationId appId) {
        this.applicationId = appId;
    }
}

