/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef __FreeBSD__
#define _WITH_GETLINE
#endif

#ifndef _UTILS_STRING_UTILS_H_
#define _UTILS_STRING_UTILS_H_

/*
 * Get numbers split by comma from a input string
 * return false/true
 */
int validate_container_id(const char* input);

/*
 * return 0 if succeeded
 */
int get_numbers_split_by_comma(const char* input, int** numbers, size_t* n_numbers);

/*
 * String format utility
 */
char *make_string(const char *fmt, ...);

/*
 * Compare string end with a suffix.
 * return 1 if succeeded
 */
int str_ends_with(const char *s, const char *suffix);
#endif
