#!/usr/bin/env bash
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

if [[ "${HADOOP_SHELL_EXECNAME}" == ozone ]]; then
   hadoop_add_profile ozone_manager
fi

_ozone_manager_hadoop_finalize() {
  if [[ "${HADOOP_CLASSNAME}" == "org.apache.hadoop.ozone.om.OzoneManagerStarter" ]] &&
     [[ -n ${OZONE_MANAGER_CLASSPATH} ]];
  then
    echo "Ozone Manager classpath extended by ${OZONE_MANAGER_CLASSPATH}"
    hadoop_add_classpath "${OZONE_MANAGER_CLASSPATH}"
  fi
}
