/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;

/**
 * Codec interface to marshall/unmarshall data to/from a byte[] based
 * key/value store.
 *
 * @param <T> Unserialized type
 */
public interface Codec<T> {

  /**
   * Convert object to raw persisted format.
   * @param object The original java object. Should not be null.
   */
  byte[] toPersistedFormat(T object) throws IOException;

  /**
   * Convert object from raw persisted format.
   *
   * @param rawData Byte array from the key/value store. Should not be null.
   */
  T fromPersistedFormat(byte[] rawData) throws IOException;

  /**
   * Copy Object from the provided object, and returns a new object.
   * @param object
   */
  T copyObject(T object);
}
