---
title: "Securing S3"
date: "2019-April-03"
summary: Ozone supports S3 protocol, and uses AWS Signature Version 4 protocol which allows a seamless S3 experience.
weight: 4
icon: cloud
---
<!---
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

To access an S3 bucket, users need AWS access key ID and AWS secret. Both of
these are generated by going to AWS website. When you use Ozone's S3
protocol, you need the same AWS access key and secret.

Under Ozone, the clients can download the access key directly from Ozone.
The user needs to `kinit` first and once they have authenticated via kerberos
 they can download the S3 access key ID and AWS secret. Just like AWS S3,
 both of these are secrets that needs to be protected by the client since it
 gives full access to the S3 buckets.


* S3 clients can get the secret access id and user secret from OzoneManager.

```bash
ozone s3 getsecret
```
This command will talk to ozone, validate the user via kerberos and generate
the AWS credentials. The values will be printed out on the screen. You can
set these values up in your _.aws_ file for automatic access while working
against Ozone S3 buckets.

<div class="alert alert-danger" role="alert">
 Please note: These S3 crediantials are like your kerberos passswords
 that give compelete access to your buckets.
</div>


* Now you can proceed to setup these secrets in aws configs:

```bash
aws configure set default.s3.signature_version s3v4
aws configure set aws_access_key_id ${accessId}
aws configure set aws_secret_access_key ${secret}
aws configure set region us-west-1
```
Please refer to AWS S3 documentation on how to use S3 via command line or via
S3 API.
