/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.SCMCLI;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CreateSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSubcommand.class);
    @CommandLine.ParentCommand
    private SCMCLI parent;
    @CommandLine.Option(description={"Owner of the new container"}, defaultValue="OZONE", required=false, names={"-o", "--owner"})
    private String owner;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.createScmClient();){
            ContainerWithPipeline container = scmClient.createContainer(this.owner);
            LOG.info("Container {} is created.", (Object)container.getContainerInfo().getContainerID());
            Void void_ = null;
            return void_;
        }
    }
}

