/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSupervisor.class);
    private final ContainerSet containerSet;
    private final ContainerReplicator replicator;
    private final ThreadPoolExecutor executor;
    private final ConcurrentHashMap.KeySetView<Object, Boolean> containersInFlight;

    public ReplicationSupervisor(ContainerSet containerSet, ContainerReplicator replicator, int poolSize) {
        this.containerSet = containerSet;
        this.replicator = replicator;
        this.containersInFlight = ConcurrentHashMap.newKeySet();
        this.executor = new ThreadPoolExecutor(0, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ContainerReplicationThread-%d").build());
    }

    public void addTask(ReplicationTask task) {
        if (this.containersInFlight.add((Object)task.getContainerId())) {
            this.executor.submit(new TaskRunner(task));
        }
    }

    public void stop() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    public int getInFlightReplications() {
        return this.containersInFlight.size();
    }

    private final class TaskRunner
    implements Runnable {
        private final ReplicationTask task;

        private TaskRunner(ReplicationTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (ReplicationSupervisor.this.containerSet.getContainer(this.task.getContainerId()) != null) {
                    LOG.debug("Container {} has already been downloaded.", (Object)this.task.getContainerId());
                    return;
                }
                this.task.setStatus(ReplicationTask.Status.DOWNLOADING);
                ReplicationSupervisor.this.replicator.replicate(this.task);
                if (this.task.getStatus() == ReplicationTask.Status.FAILED) {
                    LOG.error("Container {} can't be downloaded from any of the datanodes.", (Object)this.task.getContainerId());
                } else if (this.task.getStatus() == ReplicationTask.Status.DONE) {
                    LOG.info("Container {} is replicated.", (Object)this.task.getContainerId());
                }
            }
            finally {
                ReplicationSupervisor.this.containersInFlight.remove(this.task.getContainerId());
            }
        }
    }
}

