/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationService
extends IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationService.class);
    private final ContainerReplicationSource containerReplicationSource;

    public GrpcReplicationService(ContainerReplicationSource containerReplicationSource) {
        this.containerReplicationSource = containerReplicationSource;
    }

    public void download(ContainerProtos.CopyContainerRequestProto request, StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver) {
        LOG.info("Streaming container data ({}) to other datanode", (Object)request.getContainerID());
        try {
            GrpcOutputStream outputStream = new GrpcOutputStream(responseObserver, request.getContainerID());
            this.containerReplicationSource.copyData(request.getContainerID(), outputStream);
        }
        catch (IOException e) {
            LOG.error("Can't stream the container data", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    private static class GrpcOutputStream
    extends OutputStream
    implements Closeable {
        private static final int BUFFER_SIZE_IN_BYTES = 0x100000;
        private final StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private long containerId;
        private int readOffset = 0;
        private int writtenBytes;

        GrpcOutputStream(StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver, long containerId) {
            this.responseObserver = responseObserver;
            this.containerId = containerId;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.buffer.write(b);
                if (this.buffer.size() > 0x100000) {
                    this.flushBuffer(false);
                }
            }
            catch (Exception ex) {
                this.responseObserver.onError((Throwable)ex);
            }
        }

        private void flushBuffer(boolean eof) {
            if (this.buffer.size() > 0) {
                ContainerProtos.CopyContainerResponseProto response = ContainerProtos.CopyContainerResponseProto.newBuilder().setContainerID(this.containerId).setData(ByteString.copyFrom((byte[])this.buffer.toByteArray())).setEof(eof).setReadOffset((long)this.readOffset).setLen((long)this.buffer.size()).build();
                this.responseObserver.onNext((Object)response);
                this.readOffset += this.buffer.size();
                this.writtenBytes += this.buffer.size();
                this.buffer.reset();
            }
        }

        @Override
        public void close() throws IOException {
            this.flushBuffer(true);
            LOG.info("{} bytes written to the rpc stream from container {}", (Object)this.writtenBytes, (Object)this.containerId);
            this.responseObserver.onCompleted();
        }
    }
}

