/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationClient.class);
    private final ManagedChannel channel;
    private final IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceStub client;
    private final Path workingDirectory;

    public GrpcReplicationClient(String host, int port, Path workingDir) {
        this.channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext().maxInboundMessageSize(0x2000000)).build();
        this.client = IntraDatanodeProtocolServiceGrpc.newStub((Channel)this.channel);
        this.workingDirectory = workingDir;
    }

    public CompletableFuture<Path> download(long containerId) {
        ContainerProtos.CopyContainerRequestProto request = ContainerProtos.CopyContainerRequestProto.newBuilder().setContainerID(containerId).setLen(-1L).setReadOffset(0L).build();
        CompletableFuture<Path> response = new CompletableFuture<Path>();
        Path destinationPath = this.getWorkingDirectory().resolve("container-" + containerId + ".tar.gz");
        this.client.download(request, (StreamObserver)new StreamDownloader(containerId, response, destinationPath));
        return response;
    }

    private Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void shutdown() {
        this.channel.shutdown();
    }

    public static class StreamDownloader
    implements StreamObserver<ContainerProtos.CopyContainerResponseProto> {
        private final CompletableFuture<Path> response;
        private final long containerId;
        private BufferedOutputStream stream;
        private Path outputPath;

        public StreamDownloader(long containerId, CompletableFuture<Path> response, Path outputPath) {
            this.response = response;
            this.containerId = containerId;
            this.outputPath = outputPath;
            try {
                outputPath = (Path)Preconditions.checkNotNull((Object)outputPath);
                Path parentPath = (Path)Preconditions.checkNotNull((Object)outputPath.getParent());
                Files.createDirectories(parentPath, new FileAttribute[0]);
                this.stream = new BufferedOutputStream(new FileOutputStream(outputPath.toFile()));
            }
            catch (IOException e) {
                throw new RuntimeException("OutputPath can't be used: " + outputPath, e);
            }
        }

        public void onNext(ContainerProtos.CopyContainerResponseProto chunk) {
            try {
                this.stream.write(chunk.getData().toByteArray());
            }
            catch (IOException e) {
                this.response.completeExceptionally(e);
            }
        }

        public void onError(Throwable throwable) {
            try {
                this.stream.close();
                LOG.error("Container download was unsuccessfull", throwable);
                try {
                    Files.delete(this.outputPath);
                }
                catch (IOException ex) {
                    LOG.error("Error happened during the download but can't delete the temporary destination.", (Throwable)ex);
                }
                this.response.completeExceptionally(throwable);
            }
            catch (IOException e) {
                this.response.completeExceptionally(e);
            }
        }

        public void onCompleted() {
            try {
                this.stream.close();
                LOG.info("Container is downloaded to {}", (Object)this.outputPath);
                this.response.complete(this.outputPath);
            }
            catch (IOException e) {
                this.response.completeExceptionally(e);
            }
        }
    }
}

