/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.utils.MetadataKeyFilters;
import org.apache.hadoop.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReader
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReader.class);
    private HddsVolume hddsVolume;
    private final ContainerSet containerSet;
    private final OzoneConfiguration config;
    private final File hddsVolumeDir;
    private final VolumeSet volumeSet;

    ContainerReader(VolumeSet volSet, HddsVolume volume, ContainerSet cset, OzoneConfiguration conf) {
        Preconditions.checkNotNull((Object)volume);
        this.hddsVolume = volume;
        this.hddsVolumeDir = this.hddsVolume.getHddsRootDir();
        this.containerSet = cset;
        this.config = conf;
        this.volumeSet = volSet;
    }

    @Override
    public void run() {
        try {
            this.readVolume(this.hddsVolumeDir);
        }
        catch (RuntimeException ex) {
            LOG.info("Caught an Run time exception during reading container files from Volume {}", (Object)this.hddsVolumeDir);
        }
    }

    public void readVolume(File hddsVolumeRootDir) {
        Preconditions.checkNotNull((Object)hddsVolumeRootDir, (Object)"hddsVolumeRootDircannot be null");
        File[] scmDir = hddsVolumeRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (scmDir == null) {
            LOG.error("IO error for the volume {}, skipped loading", (Object)hddsVolumeRootDir);
            this.volumeSet.failVolume(hddsVolumeRootDir.getPath());
            return;
        }
        if (scmDir.length > 1) {
            LOG.error("Volume {} is in Inconsistent state", (Object)hddsVolumeRootDir);
            this.volumeSet.failVolume(hddsVolumeRootDir.getPath());
            return;
        }
        for (File scmLoc : scmDir) {
            File currentDir = new File(scmLoc, "current");
            File[] containerTopDirs = currentDir.listFiles();
            if (containerTopDirs == null) continue;
            for (File containerTopDir : containerTopDirs) {
                File[] containerDirs;
                if (!containerTopDir.isDirectory() || (containerDirs = containerTopDir.listFiles()) == null) continue;
                for (File containerDir : containerDirs) {
                    File containerFile = ContainerUtils.getContainerFile(containerDir);
                    long containerID = ContainerUtils.getContainerID(containerDir);
                    if (containerFile.exists()) {
                        this.verifyContainerFile(containerID, containerFile);
                        continue;
                    }
                    LOG.error("Missing .container file for ContainerID: {}", (Object)containerDir.getName());
                }
            }
        }
    }

    private void verifyContainerFile(long containerID, File containerFile) {
        try {
            ContainerData containerData = ContainerDataYaml.readContainerFile(containerFile);
            if (containerID != containerData.getContainerID()) {
                LOG.error("Invalid ContainerID in file {}. Skipping loading of this container.", (Object)containerFile);
                return;
            }
            this.verifyContainerData(containerData);
        }
        catch (IOException ex) {
            LOG.error("Failed to parse ContainerFile for ContainerID: {}", (Object)containerID, (Object)ex);
        }
    }

    public void verifyContainerData(ContainerData containerData) throws IOException {
        switch (containerData.getContainerType()) {
            case KeyValueContainer: {
                if (containerData instanceof KeyValueContainerData) {
                    byte[] bcsId;
                    KeyValueContainerData kvContainerData = (KeyValueContainerData)containerData;
                    containerData.setVolume(this.hddsVolume);
                    KeyValueContainerUtil.parseKVContainerData(kvContainerData, (Configuration)this.config);
                    KeyValueContainer kvContainer = new KeyValueContainer(kvContainerData, (Configuration)this.config);
                    MetadataStore containerDB = BlockUtils.getDB(kvContainerData, (Configuration)this.config);
                    MetadataKeyFilters.KeyPrefixFilter filter = new MetadataKeyFilters.KeyPrefixFilter().addFilter("#deleting#");
                    int numPendingDeletionBlocks = containerDB.getSequentialRangeKVs(null, Integer.MAX_VALUE, new MetadataKeyFilters.MetadataKeyFilter[]{filter}).size();
                    kvContainerData.incrPendingDeletionBlocks(numPendingDeletionBlocks);
                    byte[] delTxnId = containerDB.get(DFSUtil.string2Bytes((String)"#delTX#"));
                    if (delTxnId != null) {
                        kvContainerData.updateDeleteTransactionId(Longs.fromByteArray((byte[])delTxnId));
                    }
                    if ((bcsId = containerDB.get(DFSUtil.string2Bytes((String)"#BCSID"))) != null) {
                        kvContainerData.updateBlockCommitSequenceId(Longs.fromByteArray((byte[])bcsId));
                    }
                    this.containerSet.addContainer(kvContainer);
                    break;
                }
                throw new StorageContainerException("Container File is corrupted. ContainerType is KeyValueContainer but cast to KeyValueContainerData failed. ", ContainerProtos.Result.CONTAINER_METADATA_ERROR);
            }
            default: {
                throw new StorageContainerException("Unrecognized ContainerType " + containerData.getContainerType(), ContainerProtos.Result.UNKNOWN_CONTAINER_TYPE);
            }
        }
    }
}

