/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeIOStats;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkManagerImpl
implements ChunkManager {
    static final Logger LOG = LoggerFactory.getLogger(ChunkManagerImpl.class);

    @Override
    public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ByteBuffer data, ContainerProtos.Stage stage) throws StorageContainerException {
        try {
            KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
            HddsVolume volume = containerData.getVolume();
            VolumeIOStats volumeIOStats = volume.getVolumeIOStats();
            File chunkFile = ChunkUtils.getChunkFile(containerData, info);
            boolean isOverwrite = ChunkUtils.validateChunkForOverwrite(chunkFile, info);
            File tmpChunkFile = this.getTmpChunkFile(chunkFile, info);
            LOG.debug("writing chunk:{} chunk stage:{} chunk file:{} tmp chunk file:{}", new Object[]{info.getChunkName(), stage, chunkFile, tmpChunkFile});
            switch (stage) {
                case WRITE_DATA: {
                    if (isOverwrite) {
                        LOG.warn("ChunkFile already exists" + chunkFile + ".Deleting it.");
                        FileUtil.fullyDelete((File)chunkFile);
                    }
                    if (tmpChunkFile.exists()) {
                        LOG.warn("tmpChunkFile already exists" + tmpChunkFile + "Overwriting it.");
                    }
                    ChunkUtils.writeData(tmpChunkFile, info, data, volumeIOStats);
                    break;
                }
                case COMMIT_DATA: {
                    if (isOverwrite) {
                        LOG.warn("ChunkFile already exists" + chunkFile);
                        return;
                    }
                    this.commitChunk(tmpChunkFile, chunkFile);
                    containerData.incrBytesUsed(info.getLen());
                    containerData.incrWriteCount();
                    containerData.incrWriteBytes(info.getLen());
                    break;
                }
                case COMBINED: {
                    ChunkUtils.writeData(chunkFile, info, data, volumeIOStats);
                    if (!isOverwrite) {
                        containerData.incrBytesUsed(info.getLen());
                    }
                    containerData.incrWriteCount();
                    containerData.incrWriteBytes(info.getLen());
                    break;
                }
                default: {
                    throw new IOException("Can not identify write operation.");
                }
            }
        }
        catch (StorageContainerException ex) {
            throw ex;
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("write data failed. error: {}", (Throwable)ex);
            throw new StorageContainerException("Internal error: ", (Throwable)ex, ContainerProtos.Result.NO_SUCH_ALGORITHM);
        }
        catch (IOException | ExecutionException ex) {
            LOG.error("write data failed. error: {}", (Throwable)ex);
            throw new StorageContainerException("Internal error: ", (Throwable)ex, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("write data failed. error: {}", (Throwable)e);
            throw new StorageContainerException("Internal error: ", (Throwable)e, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
    }

    @Override
    public byte[] readChunk(Container container, BlockID blockID, ChunkInfo info) throws StorageContainerException {
        try {
            KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
            HddsVolume volume = containerData.getVolume();
            VolumeIOStats volumeIOStats = volume.getVolumeIOStats();
            if (containerData.getLayOutVersion() == ChunkLayOutVersion.getLatestVersion().getVersion()) {
                File chunkFile = ChunkUtils.getChunkFile(containerData, info);
                ByteBuffer data = ChunkUtils.readData(chunkFile, info, volumeIOStats);
                containerData.incrReadCount();
                long length = chunkFile.length();
                containerData.incrReadBytes(length);
                return data.array();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("read data failed. error: {}", (Throwable)ex);
            throw new StorageContainerException("Internal error: ", (Throwable)ex, ContainerProtos.Result.NO_SUCH_ALGORITHM);
        }
        catch (ExecutionException ex) {
            LOG.error("read data failed. error: {}", (Throwable)ex);
            throw new StorageContainerException("Internal error: ", (Throwable)ex, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("read data failed. error: {}", (Throwable)e);
            throw new StorageContainerException("Internal error: ", (Throwable)e, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
        return null;
    }

    @Override
    public void deleteChunk(Container container, BlockID blockID, ChunkInfo info) throws StorageContainerException {
        Preconditions.checkNotNull((Object)blockID, (Object)"Block ID cannot be null.");
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        if (containerData.getLayOutVersion() == ChunkLayOutVersion.getLatestVersion().getVersion()) {
            File chunkFile = ChunkUtils.getChunkFile(containerData, info);
            if (!chunkFile.exists()) {
                LOG.warn("Chunk file doe not exist. chunk info :" + info.toString());
                return;
            }
            if (info.getOffset() == 0L && info.getLen() == chunkFile.length()) {
                FileUtil.fullyDelete((File)chunkFile);
                containerData.decrBytesUsed(chunkFile.length());
            } else {
                LOG.error("Not Supported Operation. Trying to delete a chunk that is in shared file. chunk info : " + info.toString());
                throw new StorageContainerException("Not Supported Operation. Trying to delete a chunk that is in shared file. chunk info : " + info.toString(), ContainerProtos.Result.UNSUPPORTED_REQUEST);
            }
        }
    }

    @Override
    public void shutdown() {
    }

    private File getTmpChunkFile(File chunkFile, ChunkInfo info) throws StorageContainerException {
        return new File(chunkFile.getParent(), chunkFile.getName() + "." + "tmp");
    }

    private void commitChunk(File tmpChunkFile, File chunkFile) throws IOException {
        Files.move(tmpChunkFile.toPath(), chunkFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

