/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.MetadataKeyFilters;
import org.apache.hadoop.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements BlockManager {
    static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private static byte[] blockCommitSequenceIdKey = DFSUtil.string2Bytes((String)"#BCSID");
    private Configuration config;

    public BlockManagerImpl(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Config cannot be null");
        this.config = conf;
    }

    @Override
    public long putBlock(Container container, BlockData data) throws IOException {
        Preconditions.checkNotNull((Object)data, (Object)"BlockData cannot be null for put operation.");
        Preconditions.checkState((data.getContainerID() >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative");
        MetadataStore db = BlockUtils.getDB((KeyValueContainerData)container.getContainerData(), this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        long bcsId = data.getBlockCommitSequenceId();
        long containerBCSId = ((KeyValueContainerData)container.getContainerData()).getBlockCommitSequenceId();
        if (bcsId != 0L && bcsId <= containerBCSId) {
            LOG.warn("blockCommitSequenceId " + containerBCSId + " in the Container Db is greater than the supplied value " + bcsId + " .Ignoring it");
            return data.getSize();
        }
        BatchOperation batch = new BatchOperation();
        batch.put(Longs.toByteArray((long)data.getLocalID()), data.getProtoBufMessage().toByteArray());
        batch.put(blockCommitSequenceIdKey, Longs.toByteArray((long)bcsId));
        db.writeBatch(batch);
        container.updateBlockCommitSequenceId(bcsId);
        ((ContainerData)container.getContainerData()).incrKeyCount();
        return data.getSize();
    }

    @Override
    public BlockData getBlock(Container container, BlockID blockID, long bcsId) throws IOException {
        Preconditions.checkNotNull((Object)blockID, (Object)"BlockID cannot be null in GetBlock request");
        Preconditions.checkNotNull((Object)blockID.getContainerID(), (Object)"Container name cannot be null");
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = BlockUtils.getDB(containerData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        long containerBCSId = containerData.getBlockCommitSequenceId();
        if (containerBCSId < bcsId) {
            throw new StorageContainerException("Unable to find the block with bcsID " + bcsId + " .Container " + ((ContainerData)container.getContainerData()).getContainerID() + " bcsId is " + containerBCSId + ".", ContainerProtos.Result.UNKNOWN_BCSID);
        }
        byte[] kData = db.get(Longs.toByteArray((long)blockID.getLocalID()));
        if (kData == null) {
            throw new StorageContainerException("Unable to find the block.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
        ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])kData);
        long id = blockData.getBlockCommitSequenceId();
        if (id < bcsId) {
            throw new StorageContainerException("bcsId " + bcsId + " mismatches with existing block Id " + id + " for block " + blockID + ".", ContainerProtos.Result.BCSID_MISMATCH);
        }
        return BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockData);
    }

    @Override
    public long getCommittedBlockLength(Container container, BlockID blockID) throws IOException {
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = BlockUtils.getDB(containerData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        byte[] kData = db.get(Longs.toByteArray((long)blockID.getLocalID()));
        if (kData == null) {
            throw new StorageContainerException("Unable to find the block.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
        ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])kData);
        return blockData.getSize();
    }

    @Override
    public void deleteBlock(Container container, BlockID blockID) throws IOException {
        Preconditions.checkNotNull((Object)blockID, (Object)"block ID cannot be null.");
        Preconditions.checkState((blockID.getContainerID() >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Preconditions.checkState((blockID.getLocalID() >= 0L ? 1 : 0) != 0, (Object)"Local ID cannot be negative.");
        KeyValueContainerData cData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = BlockUtils.getDB(cData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        byte[] kKey = Longs.toByteArray((long)blockID.getLocalID());
        byte[] kData = db.get(kKey);
        if (kData == null) {
            throw new StorageContainerException("Unable to find the block.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
        db.delete(kKey);
        ((ContainerData)container.getContainerData()).decrKeyCount();
    }

    @Override
    public List<BlockData> listBlock(Container container, long startLocalID, int count) throws IOException {
        Preconditions.checkNotNull((Object)container, (Object)"container cannot be null");
        Preconditions.checkState((startLocalID >= 0L ? 1 : 0) != 0, (Object)"startLocal ID cannot be negative");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be a positive number.");
        container.readLock();
        ArrayList<BlockData> result = null;
        KeyValueContainerData cData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = BlockUtils.getDB(cData, this.config);
        result = new ArrayList<BlockData>();
        byte[] startKeyInBytes = Longs.toByteArray((long)startLocalID);
        List range = db.getSequentialRangeKVs(startKeyInBytes, count, new MetadataKeyFilters.MetadataKeyFilter[]{MetadataKeyFilters.getNormalKeyFilter()});
        for (Map.Entry entry : range) {
            BlockData value = BlockUtils.getBlockData((byte[])entry.getValue());
            BlockData data = new BlockData(value.getBlockID());
            result.add(data);
        }
        return result;
    }

    @Override
    public void shutdown() {
        BlockUtils.shutdownCache(ContainerCache.getInstance(this.config));
    }
}

