/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.utils.MetadataStore;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static MetadataStore getDB(KeyValueContainerData containerData, Configuration conf) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        Preconditions.checkNotNull((Object)containerData.getDbFile());
        try {
            return cache.getDB(containerData.getContainerID(), containerData.getContainerDBType(), containerData.getDbFile().getAbsolutePath(), conf);
        }
        catch (IOException ex) {
            String message = String.format("Error opening DB. Container:%s ContainerPath:%s", containerData.getContainerID(), containerData.getDbFile().getPath());
            throw new StorageContainerException(message, ContainerProtos.Result.UNABLE_TO_READ_METADATA_DB);
        }
    }

    public static void removeDB(KeyValueContainerData container, Configuration conf) {
        Preconditions.checkNotNull((Object)container);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.removeDB(container.getContainerID());
    }

    public static void shutdownCache(ContainerCache cache) {
        cache.shutdownCache();
    }

    public static BlockData getBlockData(byte[] bytes) throws IOException {
        try {
            ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])bytes);
            BlockData data = BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockData);
            return data;
        }
        catch (IOException e) {
            throw new StorageContainerException("Failed to parse block data from the bytes array.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
    }

    public static ContainerProtos.ContainerCommandResponseProto putBlockResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg, long blockLength) {
        ContainerProtos.BlockData blockData = msg.getPutBlock().getBlockData();
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder committedBlockLengthResponseBuilder = BlockUtils.getCommittedBlockLengthResponseBuilder(blockLength, blockData.getBlockID());
        committedBlockLengthResponseBuilder.setBlockCommitSequenceId(blockData.getBlockCommitSequenceId());
        ContainerProtos.PutBlockResponseProto.Builder putKeyResponse = ContainerProtos.PutBlockResponseProto.newBuilder();
        putKeyResponse.setCommittedBlockLength(committedBlockLengthResponseBuilder);
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setPutBlock(putKeyResponse);
        return builder.build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg) {
        return ContainerUtils.getSuccessResponse(msg);
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockDataResponse(ContainerProtos.ContainerCommandRequestProto msg, BlockData data) {
        ContainerProtos.GetBlockResponseProto.Builder getBlock = ContainerProtos.GetBlockResponseProto.newBuilder();
        getBlock.setBlockData(data.getProtoBufMessage());
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setGetBlock(getBlock);
        return builder.build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockLengthResponse(ContainerProtos.ContainerCommandRequestProto msg, long blockLength) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder committedBlockLengthResponseBuilder = BlockUtils.getCommittedBlockLengthResponseBuilder(blockLength, msg.getGetCommittedBlockLength().getBlockID());
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setGetCommittedBlockLength(committedBlockLengthResponseBuilder);
        return builder.build();
    }

    private static ContainerProtos.GetCommittedBlockLengthResponseProto.Builder getCommittedBlockLengthResponseBuilder(long blockLength, ContainerProtos.DatanodeBlockID blockID) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder getCommittedBlockLengthResponseBuilder = ContainerProtos.GetCommittedBlockLengthResponseProto.newBuilder();
        getCommittedBlockLengthResponseBuilder.setBlockLength(blockLength);
        getCommittedBlockLengthResponseBuilder.setBlockID(blockID);
        return getCommittedBlockLengthResponseBuilder;
    }
}

