/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;

public class TarContainerPacker
implements ContainerPacker<KeyValueContainerData> {
    private static final String CHUNKS_DIR_NAME = "chunks";
    private static final String DB_DIR_NAME = "db";
    private static final String CONTAINER_FILE_NAME = "container.yaml";

    @Override
    public byte[] unpackContainerData(Container<KeyValueContainerData> container, InputStream inputStream) throws IOException {
        byte[] descriptorFileContent = null;
        try {
            KeyValueContainerData containerData = container.getContainerData();
            CompressorInputStream compressorInputStream = new CompressorStreamFactory().createCompressorInputStream("gz", inputStream);
            TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)compressorInputStream);
            TarArchiveEntry entry = tarInput.getNextTarEntry();
            while (entry != null) {
                Path destinationPath;
                String name = entry.getName();
                if (name.startsWith("db/")) {
                    destinationPath = containerData.getDbFile().toPath().resolve(name.substring(DB_DIR_NAME.length() + 1));
                    this.extractEntry(tarInput, entry.getSize(), destinationPath);
                } else if (name.startsWith("chunks/")) {
                    destinationPath = Paths.get(containerData.getChunksPath(), new String[0]).resolve(name.substring(CHUNKS_DIR_NAME.length() + 1));
                    this.extractEntry(tarInput, entry.getSize(), destinationPath);
                } else if (name.equals(CONTAINER_FILE_NAME)) {
                    descriptorFileContent = this.readEntry(tarInput, entry);
                } else {
                    throw new IllegalArgumentException("Unknown entry in the tar file: " + name);
                }
                entry = tarInput.getNextTarEntry();
            }
            return descriptorFileContent;
        }
        catch (CompressorException e) {
            throw new IOException("Can't uncompress the given container: " + container.getContainerData().getContainerID(), e);
        }
    }

    private void extractEntry(TarArchiveInputStream tarInput, long size, Path path) throws IOException {
        Preconditions.checkNotNull((Object)path, (Object)"Path element should not be null");
        Path parent = (Path)Preconditions.checkNotNull((Object)path.getParent(), (Object)"Path element should have a parent directory");
        Files.createDirectories(parent, new FileAttribute[0]);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path.toAbsolutePath().toString()));){
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize + 1];
            long remaining = size;
            while (remaining > 0L) {
                int read = tarInput.read(buffer, 0, (int)Math.min(remaining, (long)bufferSize));
                if (read >= 0) {
                    remaining -= (long)read;
                    bos.write(buffer, 0, read);
                    continue;
                }
                remaining = 0L;
            }
        }
    }

    @Override
    public void pack(Container<KeyValueContainerData> container, OutputStream destination) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        try (CompressorOutputStream gzippedOut = new CompressorStreamFactory().createCompressorOutputStream("gz", destination);
             TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)gzippedOut);){
            this.includePath(containerData.getDbFile().toString(), DB_DIR_NAME, (ArchiveOutputStream)archiveOutputStream);
            this.includePath(containerData.getChunksPath(), CHUNKS_DIR_NAME, (ArchiveOutputStream)archiveOutputStream);
            this.includeFile(container.getContainerFile(), CONTAINER_FILE_NAME, (ArchiveOutputStream)archiveOutputStream);
        }
        catch (CompressorException e) {
            throw new IOException("Can't compress the container: " + containerData.getContainerID(), e);
        }
    }

    @Override
    public byte[] unpackContainerDescriptor(InputStream inputStream) throws IOException {
        try {
            CompressorInputStream compressorInputStream = new CompressorStreamFactory().createCompressorInputStream("gz", inputStream);
            TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)compressorInputStream);
            TarArchiveEntry entry = tarInput.getNextTarEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.equals(CONTAINER_FILE_NAME)) {
                    return this.readEntry(tarInput, entry);
                }
                entry = tarInput.getNextTarEntry();
            }
        }
        catch (CompressorException e) {
            throw new IOException("Can't read the container descriptor from the container archive", e);
        }
        throw new IOException("Container descriptor is missing from the container archive.");
    }

    private byte[] readEntry(TarArchiveInputStream tarInput, TarArchiveEntry entry) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize + 1];
        for (long remaining = entry.getSize(); remaining > 0L; remaining -= (long)read) {
            read = tarInput.read(buffer, 0, (int)Math.min(remaining, (long)bufferSize));
            bos.write(buffer, 0, read);
        }
        return bos.toByteArray();
    }

    private void includePath(String containerPath, String subdir, ArchiveOutputStream archiveOutputStream) throws IOException {
        for (Path path : Files.list(Paths.get(containerPath, new String[0])).collect(Collectors.toList())) {
            this.includeFile(path.toFile(), subdir + "/" + path.getFileName(), archiveOutputStream);
        }
    }

    private void includeFile(File file, String entryName, ArchiveOutputStream archiveOutputStream) throws IOException {
        ArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry(file, entryName);
        archiveOutputStream.putArchiveEntry(archiveEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }
}

