/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.OpenContainerBlockMap;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.keyvalue.helpers.SmallFileUtils;
import org.apache.hadoop.ozone.container.keyvalue.impl.BlockManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHandler
extends Handler {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueHandler.class);
    private final ContainerProtos.ContainerType containerType = ContainerProtos.ContainerType.KeyValueContainer;
    private final BlockManager blockManager;
    private final ChunkManager chunkManager;
    private final BlockDeletingService blockDeletingService;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long maxContainerSize;
    private final AutoCloseableLock handlerLock;
    private final OpenContainerBlockMap openContainerBlockMap;

    public KeyValueHandler(Configuration config, ContainerSet contSet, VolumeSet volSet, ContainerMetrics metrics) {
        super(config, contSet, volSet, metrics);
        this.blockManager = new BlockManagerImpl(config);
        this.chunkManager = new ChunkManagerImpl();
        long svcInterval = config.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
        long serviceTimeout = config.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new BlockDeletingService(this.containerSet, svcInterval, serviceTimeout, TimeUnit.MILLISECONDS, config);
        this.blockDeletingService.start();
        this.volumeChoosingPolicy = (VolumeChoosingPolicy)ReflectionUtils.newInstance((Class)this.conf.getClass("hdds.datanode.volume.choosing.policy", RoundRobinVolumeChoosingPolicy.class, VolumeChoosingPolicy.class), (Configuration)this.conf);
        this.maxContainerSize = (long)config.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.handlerLock = new AutoCloseableLock((Lock)new ReentrantLock(true));
        this.openContainerBlockMap = new OpenContainerBlockMap();
    }

    @VisibleForTesting
    public VolumeChoosingPolicy getVolumeChoosingPolicyForTesting() {
        return this.volumeChoosingPolicy;
    }

    public OpenContainerBlockMap getOpenContainerBlockMap() {
        return this.openContainerBlockMap;
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto request, Container container) {
        ContainerProtos.Type cmdType = request.getCmdType();
        KeyValueContainer kvContainer = (KeyValueContainer)container;
        switch (cmdType) {
            case CreateContainer: {
                return this.handleCreateContainer(request, kvContainer);
            }
            case ReadContainer: {
                return this.handleReadContainer(request, kvContainer);
            }
            case UpdateContainer: {
                return this.handleUpdateContainer(request, kvContainer);
            }
            case DeleteContainer: {
                return this.handleDeleteContainer(request, kvContainer);
            }
            case ListContainer: {
                return this.handleUnsupportedOp(request);
            }
            case CloseContainer: {
                return this.handleCloseContainer(request, kvContainer);
            }
            case PutBlock: {
                return this.handlePutBlock(request, kvContainer);
            }
            case GetBlock: {
                return this.handleGetBlock(request, kvContainer);
            }
            case DeleteBlock: {
                return this.handleDeleteBlock(request, kvContainer);
            }
            case ListBlock: {
                return this.handleUnsupportedOp(request);
            }
            case ReadChunk: {
                return this.handleReadChunk(request, kvContainer);
            }
            case DeleteChunk: {
                return this.handleDeleteChunk(request, kvContainer);
            }
            case WriteChunk: {
                return this.handleWriteChunk(request, kvContainer);
            }
            case ListChunk: {
                return this.handleUnsupportedOp(request);
            }
            case CompactChunk: {
                return this.handleUnsupportedOp(request);
            }
            case PutSmallFile: {
                return this.handlePutSmallFile(request, kvContainer);
            }
            case GetSmallFile: {
                return this.handleGetSmallFile(request, kvContainer);
            }
            case GetCommittedBlockLength: {
                return this.handleGetCommittedBlockLength(request, kvContainer);
            }
        }
        return null;
    }

    @VisibleForTesting
    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    @VisibleForTesting
    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerProtos.ContainerCommandResponseProto handleCreateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCreateContainer()) {
            LOG.debug("Malformed Create Container request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        Preconditions.checkArgument((kvContainer == null ? 1 : 0) != 0);
        long containerID = request.getContainerID();
        KeyValueContainerData newContainerData = new KeyValueContainerData(containerID, this.maxContainerSize);
        KeyValueContainer newContainer = new KeyValueContainer(newContainerData, this.conf);
        try {
            this.handlerLock.acquire();
            if (this.containerSet.getContainer(containerID) == null) {
                newContainer.create(this.volumeSet, this.volumeChoosingPolicy, this.scmID);
                this.containerSet.addContainer(newContainer);
            } else {
                LOG.warn("Container already exists.container Id " + containerID);
            }
        }
        catch (StorageContainerException ex) {
            ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = ContainerUtils.logAndReturnError(LOG, ex, request);
            return containerCommandResponseProto;
        }
        finally {
            this.handlerLock.release();
        }
        return ContainerUtils.getSuccessResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateContainerPathFields(KeyValueContainer container, long maxSize) throws IOException {
        this.volumeSet.readLock();
        try {
            HddsVolume containerVolume = this.volumeChoosingPolicy.chooseVolume(this.volumeSet.getVolumesList(), maxSize);
            String hddsVolumeDir = containerVolume.getHddsRootDir().toString();
            container.populatePathFields(this.scmID, containerVolume, hddsVolumeDir);
        }
        finally {
            this.volumeSet.readUnlock();
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleReadContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasReadContainer()) {
            LOG.debug("Malformed Read Container request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        KeyValueContainerData containerData = kvContainer.getContainerData();
        return KeyValueContainerUtil.getReadContainerResponse(request, containerData);
    }

    ContainerProtos.ContainerCommandResponseProto handleUpdateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasUpdateContainer()) {
            LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        boolean forceUpdate = request.getUpdateContainer().getForceUpdate();
        List keyValueList = request.getUpdateContainer().getMetadataList();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (ContainerProtos.KeyValue keyValue : keyValueList) {
            metadata.put(keyValue.getKey(), keyValue.getValue());
        }
        try {
            if (!metadata.isEmpty()) {
                kvContainer.update(metadata, forceUpdate);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerUtils.getSuccessResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerProtos.ContainerCommandResponseProto handleDeleteContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteContainer()) {
            LOG.debug("Malformed Delete container request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        boolean forceDelete = request.getDeleteContainer().getForceDelete();
        kvContainer.writeLock();
        try {
            if (kvContainer.getContainerData().isOpen()) {
                kvContainer.writeUnlock();
                throw new StorageContainerException("Deletion of Open Container is not allowed.", ContainerProtos.Result.DELETE_ON_OPEN_CONTAINER);
            }
            if (!forceDelete && kvContainer.getContainerData().getKeyCount() > 0L) {
                kvContainer.writeUnlock();
                throw new StorageContainerException("Container cannot be deleted because it is not empty.", ContainerProtos.Result.ERROR_CONTAINER_NOT_EMPTY);
            }
            long containerId = kvContainer.getContainerData().getContainerID();
            this.containerSet.removeContainer(containerId);
            this.openContainerBlockMap.removeContainer(containerId);
            kvContainer.writeUnlock();
            kvContainer.delete(forceDelete);
        }
        catch (StorageContainerException ex) {
            ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = ContainerUtils.logAndReturnError(LOG, ex, request);
            return containerCommandResponseProto;
        }
        finally {
            if (kvContainer.hasWriteLock()) {
                kvContainer.writeUnlock();
            }
        }
        return ContainerUtils.getSuccessResponse(request);
    }

    ContainerProtos.ContainerCommandResponseProto handleCloseContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCloseContainer()) {
            LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        long containerID = kvContainer.getContainerData().getContainerID();
        ContainerProtos.ContainerLifeCycleState containerState = kvContainer.getContainerState();
        try {
            if (containerState == ContainerProtos.ContainerLifeCycleState.CLOSED) {
                LOG.debug("Container {} is already closed.", (Object)containerID);
                return ContainerUtils.getSuccessResponse(request);
            }
            if (containerState == ContainerProtos.ContainerLifeCycleState.INVALID) {
                LOG.debug("Invalid container data. ContainerID: {}", (Object)containerID);
                throw new StorageContainerException("Invalid container data. ContainerID: " + containerID, ContainerProtos.Result.INVALID_CONTAINER_STATE);
            }
            KeyValueContainerData kvData = kvContainer.getContainerData();
            kvData.setState(ContainerProtos.ContainerLifeCycleState.CLOSING);
            this.commitPendingBlocks(kvContainer);
            kvContainer.close();
            this.openContainerBlockMap.removeContainer(kvData.getContainerID());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Close Container failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerUtils.getSuccessResponse(request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        long blockLength;
        if (!request.hasPutBlock()) {
            LOG.debug("Malformed Put Key request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)request.getPutBlock().getBlockData());
            long numBytes = blockData.getProtoBufMessage().toByteArray().length;
            blockLength = this.commitKey(blockData, kvContainer);
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Put Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return BlockUtils.putBlockResponseSuccess(request, blockLength);
    }

    private void commitPendingBlocks(KeyValueContainer kvContainer) throws IOException {
        long containerId = kvContainer.getContainerData().getContainerID();
        List<BlockData> pendingBlocks = this.openContainerBlockMap.getOpenBlocks(containerId);
        for (BlockData blockData : pendingBlocks) {
            this.commitKey(blockData, kvContainer);
        }
    }

    private long commitKey(BlockData blockData, KeyValueContainer kvContainer) throws IOException {
        Preconditions.checkNotNull((Object)blockData);
        long length = this.blockManager.putBlock(kvContainer, blockData);
        this.openContainerBlockMap.removeFromBlockMap(blockData.getBlockID());
        return length;
    }

    ContainerProtos.ContainerCommandResponseProto handleGetBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        BlockData responseData;
        if (!request.hasGetBlock()) {
            LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetBlock().getBlockID());
            responseData = this.blockManager.getBlock(kvContainer, blockID, request.getGetBlock().getBlockCommitSequenceId());
            long numBytes = responseData.getProtoBufMessage().toByteArray().length;
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Get Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return BlockUtils.getBlockDataResponse(request, responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetCommittedBlockLength(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        long blockLength;
        if (!request.hasGetCommittedBlockLength()) {
            LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetCommittedBlockLength().getBlockID());
            if (this.openContainerBlockMap.checkIfBlockExists(blockID)) {
                String msg = "Block " + blockID + " is not committed yet.";
                throw new StorageContainerException(msg, ContainerProtos.Result.BLOCK_NOT_COMMITTED);
            }
            blockLength = this.blockManager.getCommittedBlockLength(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("GetCommittedBlockLength failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return BlockUtils.getBlockLengthResponse(request, blockLength);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteBlock()) {
            LOG.debug("Malformed Delete Key request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getDeleteBlock().getBlockID());
            this.blockManager.deleteBlock(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Delete Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return BlockUtils.getBlockResponseSuccess(request);
    }

    ContainerProtos.ContainerCommandResponseProto handleReadChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        byte[] data;
        ChunkInfo chunkInfo;
        if (!request.hasReadChunk()) {
            LOG.debug("Malformed Read Chunk request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getReadChunk().getBlockID());
            chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)request.getReadChunk().getChunkData());
            Preconditions.checkNotNull((Object)chunkInfo);
            data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo);
            this.metrics.incContainerBytesStats(ContainerProtos.Type.ReadChunk, data.length);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ChunkUtils.getReadChunkResponse(request, data, chunkInfo);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteChunk()) {
            LOG.debug("Malformed Delete Chunk request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getDeleteChunk().getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = request.getDeleteChunk().getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            this.chunkManager.deleteChunk(kvContainer, blockID, chunkInfo);
            this.openContainerBlockMap.removeChunk(blockID, chunkInfoProto);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Delete Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ChunkUtils.getChunkResponseSuccess(request);
    }

    ContainerProtos.ContainerCommandResponseProto handleWriteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasWriteChunk()) {
            LOG.debug("Malformed Write Chunk request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getWriteChunk().getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = request.getWriteChunk().getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ByteBuffer data = null;
            if (request.getWriteChunk().getStage() == ContainerProtos.Stage.WRITE_DATA || request.getWriteChunk().getStage() == ContainerProtos.Stage.COMBINED) {
                data = request.getWriteChunk().getData().asReadOnlyByteBuffer();
            }
            this.chunkManager.writeChunk(kvContainer, blockID, chunkInfo, data, request.getWriteChunk().getStage());
            if (request.getWriteChunk().getStage() == ContainerProtos.Stage.WRITE_DATA || request.getWriteChunk().getStage() == ContainerProtos.Stage.COMBINED) {
                this.metrics.incContainerBytesStats(ContainerProtos.Type.WriteChunk, request.getWriteChunk().getChunkData().getLen());
            }
            if (request.getWriteChunk().getStage() == ContainerProtos.Stage.COMMIT_DATA || request.getWriteChunk().getStage() == ContainerProtos.Stage.COMBINED) {
                this.openContainerBlockMap.addChunk(blockID, chunkInfoProto);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ChunkUtils.getChunkResponseSuccess(request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasPutSmallFile()) {
            LOG.debug("Malformed Put Small File request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        ContainerProtos.PutSmallFileRequestProto putSmallFileReq = request.getPutSmallFile();
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)putSmallFileReq.getBlock().getBlockData().getBlockID());
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)putSmallFileReq.getBlock().getBlockData());
            Preconditions.checkNotNull((Object)blockData);
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)putSmallFileReq.getChunkInfo());
            Preconditions.checkNotNull((Object)chunkInfo);
            ByteBuffer data = putSmallFileReq.getData().asReadOnlyByteBuffer();
            this.chunkManager.writeChunk(kvContainer, blockID, chunkInfo, data, ContainerProtos.Stage.COMBINED);
            LinkedList<ContainerProtos.ChunkInfo> chunks = new LinkedList<ContainerProtos.ChunkInfo>();
            chunks.add(chunkInfo.getProtoBufMessage());
            blockData.setChunks(chunks);
            this.blockManager.putBlock(kvContainer, blockData);
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutSmallFile, data.capacity());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.PUT_SMALL_FILE_ERROR), request);
        }
        return SmallFileUtils.getPutFileResponseSuccess(request);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasGetSmallFile()) {
            LOG.debug("Malformed Get Small File request. trace ID: {}", (Object)request.getTraceID());
            return ContainerUtils.malformedRequest(request);
        }
        ContainerProtos.GetSmallFileRequestProto getSmallFileReq = request.getGetSmallFile();
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)getSmallFileReq.getBlock().getBlockID());
            BlockData responseData = this.blockManager.getBlock(kvContainer, blockID, 0L);
            ContainerProtos.ChunkInfo chunkInfo = null;
            ByteString dataBuf = ByteString.EMPTY;
            for (ContainerProtos.ChunkInfo chunk : responseData.getChunks()) {
                byte[] data = this.chunkManager.readChunk(kvContainer, blockID, ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk));
                ByteString current = ByteString.copyFrom((byte[])data);
                dataBuf = dataBuf.concat(current);
                chunkInfo = chunk;
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetSmallFile, dataBuf.size());
            return SmallFileUtils.getGetSmallFileResponseSuccess(request, dataBuf.toByteArray(), ChunkInfo.getFromProtoBuf(chunkInfo));
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.GET_SMALL_FILE_ERROR), request);
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleUnsupportedOp(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerUtils.unsupportedRequest(request);
    }

    private void checkContainerOpen(KeyValueContainer kvContainer) throws StorageContainerException {
        ContainerProtos.ContainerLifeCycleState containerState = kvContainer.getContainerState();
        if (containerState == ContainerProtos.ContainerLifeCycleState.OPEN) {
            return;
        }
        String msg = "Requested operation not allowed as ContainerState is " + containerState;
        ContainerProtos.Result result = null;
        switch (containerState) {
            case CLOSING: 
            case CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case INVALID: {
                result = ContainerProtos.Result.INVALID_CONTAINER_STATE;
                break;
            }
            default: {
                result = ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
            }
        }
        throw new StorageContainerException(msg, result);
    }

    @Override
    public Container importContainer(long containerID, long maxSize, FileInputStream rawContainerStream, TarContainerPacker packer) throws IOException {
        KeyValueContainerData containerData = new KeyValueContainerData(containerID, maxSize);
        KeyValueContainer container = new KeyValueContainer(containerData, this.conf);
        this.populateContainerPathFields(container, maxSize);
        container.importContainerData((InputStream)rawContainerStream, packer);
        return container;
    }
}

