/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.StorageSize;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.yaml.snakeyaml.nodes.Tag;

public class KeyValueContainerData
extends ContainerData {
    public static final Tag KEYVALUE_YAML_TAG = new Tag("KeyValueContainerData");
    private static final List<String> KV_YAML_FIELDS = Lists.newArrayList();
    private String metadataPath;
    private String chunksPath;
    private String containerDBType;
    private File dbFile = null;
    private final AtomicInteger numPendingDeletionBlocks = new AtomicInteger(0);
    private long deleteTransactionId = 0L;
    private long blockCommitSequenceId;

    public KeyValueContainerData(long id, long size) {
        super(ContainerProtos.ContainerType.KeyValueContainer, id, size);
    }

    public KeyValueContainerData(long id, int layOutVersion, long size) {
        super(ContainerProtos.ContainerType.KeyValueContainer, id, layOutVersion, size);
    }

    public void setDbFile(File containerDbFile) {
        this.dbFile = containerDbFile;
    }

    public File getDbFile() {
        return this.dbFile;
    }

    public String getMetadataPath() {
        return this.metadataPath;
    }

    public void setMetadataPath(String path) {
        this.metadataPath = path;
    }

    @Override
    public String getContainerPath() {
        if (this.metadataPath == null) {
            return null;
        }
        return new File(this.metadataPath).getParent();
    }

    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    public void updateBlockCommitSequenceId(long id) {
        this.blockCommitSequenceId = id;
    }

    public String getChunksPath() {
        return this.chunksPath;
    }

    public void setChunksPath(String chunkPath) {
        this.chunksPath = chunkPath;
    }

    public String getContainerDBType() {
        return this.containerDBType;
    }

    public void setContainerDBType(String containerDBType) {
        this.containerDBType = containerDBType;
    }

    public void incrPendingDeletionBlocks(int numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(numBlocks);
    }

    public void decrPendingDeletionBlocks(int numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(-1 * numBlocks);
    }

    public int getNumPendingDeletionBlocks() {
        return this.numPendingDeletionBlocks.get();
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    @Override
    public ContainerProtos.ContainerData getProtoBufMessage() {
        ContainerProtos.ContainerData.Builder builder = ContainerProtos.ContainerData.newBuilder();
        builder.setContainerID(this.getContainerID());
        builder.setContainerPath(this.getMetadataPath());
        builder.setState(this.getState());
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        if (this.getBytesUsed() >= 0L) {
            builder.setBytesUsed(this.getBytesUsed());
        }
        if (this.getContainerType() != null) {
            builder.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        }
        return builder.build();
    }

    public static List<String> getYamlFields() {
        return Collections.unmodifiableList(KV_YAML_FIELDS);
    }

    @VisibleForTesting
    public static KeyValueContainerData getFromProtoBuf(ContainerProtos.ContainerData protoData) throws IOException {
        StorageSize storageSize = StorageSize.parse((String)"5GB");
        KeyValueContainerData data = new KeyValueContainerData(protoData.getContainerID(), (long)storageSize.getUnit().toBytes(storageSize.getValue()));
        for (int x = 0; x < protoData.getMetadataCount(); ++x) {
            data.addMetadata(protoData.getMetadata(x).getKey(), protoData.getMetadata(x).getValue());
        }
        if (protoData.hasContainerPath()) {
            String metadataPath = protoData.getContainerPath() + File.separator + "metadata";
            data.setMetadataPath(metadataPath);
        }
        if (protoData.hasState()) {
            data.setState(protoData.getState());
        }
        if (protoData.hasBytesUsed()) {
            data.setBytesUsed(protoData.getBytesUsed());
        }
        return data;
    }

    static {
        KV_YAML_FIELDS.addAll(YAML_FIELDS);
        KV_YAML_FIELDS.add("metadataPath");
        KV_YAML_FIELDS.add("chunksPath");
        KV_YAML_FIELDS.add("containerDBType");
    }
}

