/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.utils.MetaStoreIterator;
import org.apache.hadoop.utils.MetadataKeyFilters;
import org.apache.hadoop.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class KeyValueBlockIterator
implements BlockIterator<BlockData> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueBlockIterator.class);
    private MetaStoreIterator<MetadataStore.KeyValue> blockIterator;
    private static MetadataKeyFilters.KeyPrefixFilter defaultBlockFilter = MetadataKeyFilters.getNormalKeyFilter();
    private MetadataKeyFilters.KeyPrefixFilter blockFilter;
    private BlockData nextBlock;
    private long containerId;

    public KeyValueBlockIterator(long id, File path) throws IOException {
        this(id, path, defaultBlockFilter);
    }

    public KeyValueBlockIterator(long id, File path, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        this.containerId = id;
        File metdataPath = new File(path, "metadata");
        File containerFile = ContainerUtils.getContainerFile(metdataPath.getParentFile());
        ContainerData containerData = ContainerDataYaml.readContainerFile(containerFile);
        KeyValueContainerData keyValueContainerData = (KeyValueContainerData)containerData;
        keyValueContainerData.setDbFile(KeyValueContainerLocationUtil.getContainerDBFile(metdataPath, this.containerId));
        MetadataStore metadataStore = BlockUtils.getDB(keyValueContainerData, (Configuration)new OzoneConfiguration());
        this.blockIterator = metadataStore.iterator();
        this.blockFilter = filter;
    }

    @Override
    public BlockData nextBlock() throws IOException, NoSuchElementException {
        if (this.nextBlock != null) {
            BlockData currentBlock = this.nextBlock;
            this.nextBlock = null;
            return currentBlock;
        }
        if (this.hasNext()) {
            return this.nextBlock();
        }
        throw new NoSuchElementException("Block Iterator reached end for ContainerID " + this.containerId);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.nextBlock != null) {
            return true;
        }
        if (this.blockIterator.hasNext()) {
            MetadataStore.KeyValue block = (MetadataStore.KeyValue)this.blockIterator.next();
            if (this.blockFilter.filterKey(null, block.getKey(), null)) {
                this.nextBlock = BlockUtils.getBlockData(block.getValue());
                LOG.trace("Block matching with filter found: blockID is : {} for containerID {}", (Object)this.nextBlock.getLocalID(), (Object)this.containerId);
                return true;
            }
            this.hasNext();
        }
        return false;
    }

    @Override
    public void seekToFirst() {
        this.nextBlock = null;
        this.blockIterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.nextBlock = null;
        this.blockIterator.seekToLast();
    }
}

