/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUsage {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeUsage.class);
    private final File rootDir;
    private final DF df;
    private final File scmUsedFile;
    private GetSpaceUsed scmUsage;
    private static final String DU_CACHE_FILE = "scmUsed";
    private volatile boolean scmUsedSaved = false;

    VolumeUsage(File dataLoc, Configuration conf) throws IOException {
        this.rootDir = dataLoc;
        this.scmUsedFile = new File(this.rootDir, DU_CACHE_FILE);
        this.df = new DF(this.rootDir, conf);
        this.startScmUsageThread(conf);
    }

    void startScmUsageThread(Configuration conf) throws IOException {
        this.scmUsage = new GetSpaceUsed.Builder().setPath(this.rootDir).setConf(conf).setInitialUsed(this.loadScmUsed()).build();
    }

    long getCapacity() {
        long capacity = this.df.getCapacity();
        return capacity > 0L ? capacity : 0L;
    }

    long getAvailable() throws IOException {
        long available;
        long remaining = this.getCapacity() - this.getScmUsed();
        if (remaining > (available = this.df.getAvailable())) {
            remaining = available;
        }
        return remaining > 0L ? remaining : 0L;
    }

    long getScmUsed() throws IOException {
        return this.scmUsage.getUsed();
    }

    public void shutdown() {
        this.saveScmUsed();
        if (this.scmUsage instanceof CachingGetSpaceUsed) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{(CachingGetSpaceUsed)this.scmUsage});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadScmUsed() {
        Scanner sc;
        try {
            sc = new Scanner(this.scmUsedFile, "UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedScmUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && Time.now() - mtime < 600000L) {
                LOG.info("Cached ScmUsed found for {} : {} ", (Object)this.rootDir, (Object)cachedScmUsed);
                long l = cachedScmUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveScmUsed() {
        OutputStreamWriter out;
        block5: {
            if (this.scmUsedFile.exists() && !this.scmUsedFile.delete()) {
                LOG.warn("Failed to delete old scmUsed file in {}.", (Object)this.rootDir);
            }
            out = null;
            try {
                long used = this.getScmUsed();
                if (used <= 0L) break block5;
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.scmUsedFile), StandardCharsets.UTF_8);
                out.write(Long.toString(used) + " " + Long.toString(Time.now()));
                out.flush();
                out.close();
                out = null;
            }
            catch (IOException ioe) {
                try {
                    LOG.warn("Failed to write scmUsed to " + this.scmUsedFile, (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{out});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{out});
            }
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{out});
    }

    @VisibleForTesting
    public void setScmUsageForTesting(GetSpaceUsed scmUsageForTest) {
        this.scmUsage = scmUsageForTest;
    }
}

