/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeInfo.class);
    private final String rootDir;
    private final StorageType storageType;
    private VolumeUsage usage;
    private long configuredCapacity;

    private VolumeInfo(Builder b) throws IOException {
        this.rootDir = b.rootDir;
        File root = new File(this.rootDir);
        Boolean succeeded = root.isDirectory() || root.mkdirs();
        if (!succeeded.booleanValue()) {
            LOG.error("Unable to create the volume root dir at : {}", (Object)root);
            throw new IOException("Unable to create the volume root dir at " + root);
        }
        this.storageType = b.storageType != null ? b.storageType : StorageType.DEFAULT;
        this.configuredCapacity = b.configuredCapacity != 0L ? b.configuredCapacity : -1L;
        this.usage = new VolumeUsage(root, b.conf);
    }

    public long getCapacity() throws IOException {
        if (this.configuredCapacity < 0L) {
            if (this.usage == null) {
                throw new IOException("Volume Usage thread is not running. This error is usually seen during DataNode shutdown.");
            }
            return this.usage.getCapacity();
        }
        return this.configuredCapacity;
    }

    public long getAvailable() throws IOException {
        if (this.usage == null) {
            throw new IOException("Volume Usage thread is not running. This error is usually seen during DataNode shutdown.");
        }
        return this.usage.getAvailable();
    }

    public long getScmUsed() throws IOException {
        if (this.usage == null) {
            throw new IOException("Volume Usage thread is not running. This error is usually seen during DataNode shutdown.");
        }
        return this.usage.getScmUsed();
    }

    protected void shutdownUsageThread() {
        if (this.usage != null) {
            this.usage.shutdown();
        }
        this.usage = null;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    @VisibleForTesting
    public void setScmUsageForTesting(GetSpaceUsed scmUsageForTest) {
        this.usage.setScmUsageForTesting(scmUsageForTest);
    }

    @VisibleForTesting
    public VolumeUsage getUsageForTesting() {
        return this.usage;
    }

    public static class Builder {
        private final Configuration conf;
        private final String rootDir;
        private StorageType storageType;
        private long configuredCapacity;

        public Builder(String root, Configuration config) {
            this.rootDir = root;
            this.conf = config;
        }

        public Builder storageType(StorageType st) {
            this.storageType = st;
            return this;
        }

        public Builder configuredCapacity(long capacity) {
            this.configuredCapacity = capacity;
            return this;
        }

        public VolumeInfo build() throws IOException {
            return new VolumeInfo(this);
        }
    }
}

