/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.util.DiskChecker;

public class RoundRobinVolumeChoosingPolicy
implements VolumeChoosingPolicy {
    public static final Log LOG = LogFactory.getLog(RoundRobinVolumeChoosingPolicy.class);
    private AtomicInteger nextVolumeIndex = new AtomicInteger(0);

    @Override
    public HddsVolume chooseVolume(List<HddsVolume> volumes, long maxContainerSize) throws IOException {
        int currentVolumeIndex;
        if (volumes.size() < 1) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        int nextIndex = this.nextVolumeIndex.get();
        int startVolumeIndex = currentVolumeIndex = nextIndex < volumes.size() ? nextIndex : 0;
        long maxAvailable = 0L;
        do {
            HddsVolume volume = volumes.get(currentVolumeIndex);
            long availableVolumeSize = volume.getAvailable();
            currentVolumeIndex = (currentVolumeIndex + 1) % volumes.size();
            if (availableVolumeSize > maxContainerSize) {
                this.nextVolumeIndex.compareAndSet(nextIndex, currentVolumeIndex);
                return volume;
            }
            if (availableVolumeSize <= maxAvailable) continue;
            maxAvailable = availableVolumeSize;
        } while (currentVolumeIndex != startVolumeIndex);
        throw new DiskChecker.DiskOutOfSpaceException("Out of space: The volume with the most available space (=" + maxAvailable + " B) is less than the container size (=" + maxContainerSize + " B).");
    }
}

