/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.RatisHelper;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerRatis
implements XceiverServerSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverServerRatis.class);
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private final int port;
    private final RaftServer server;
    private ThreadPoolExecutor chunkExecutor;
    private final List<ExecutorService> executors;
    private final ContainerDispatcher dispatcher;
    private ClientId clientId = ClientId.randomId();
    private final StateContext context;
    private final RaftProtos.ReplicationLevel replicationLevel;
    private long nodeFailureTimeoutMs;

    private static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private XceiverServerRatis(DatanodeDetails dd, int port, ContainerDispatcher dispatcher, Configuration conf, StateContext context) throws IOException {
        Objects.requireNonNull(dd, "id == null");
        this.port = port;
        RaftProperties serverProperties = this.newRaftProperties(conf);
        int numWriteChunkThreads = conf.getInt("dfs.container.ratis.num.write.chunk.threads", 60);
        this.chunkExecutor = new ThreadPoolExecutor(numWriteChunkThreads, numWriteChunkThreads, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.CallerRunsPolicy());
        int numContainerOpExecutors = conf.getInt("dfs.container.ratis.num.container.op.executors", 10);
        this.context = context;
        this.replicationLevel = (RaftProtos.ReplicationLevel)conf.getEnum("dfs.container.ratis.replication.level", (Enum)OzoneConfigKeys.DFS_CONTAINER_RATIS_REPLICATION_LEVEL_DEFAULT);
        this.executors = new ArrayList<ExecutorService>();
        this.dispatcher = dispatcher;
        for (int i = 0; i < numContainerOpExecutors; ++i) {
            this.executors.add(Executors.newSingleThreadExecutor());
        }
        this.server = RaftServer.newBuilder().setServerId(RatisHelper.toRaftPeerId((DatanodeDetails)dd)).setProperties(serverProperties).setStateMachineRegistry(this::getStateMachine).build();
    }

    private ContainerStateMachine getStateMachine(RaftGroupId gid) {
        return new ContainerStateMachine(gid, this.dispatcher, this.chunkExecutor, this, Collections.unmodifiableList(this.executors));
    }

    private RaftProperties newRaftProperties(Configuration conf) {
        RaftProperties properties = new RaftProperties();
        String rpcType = conf.get("dfs.container.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)rpcType);
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpc);
        int raftSegmentSize = conf.getInt("dfs.container.ratis.segment.size", 16384);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        int raftSegmentPreallocatedSize = conf.getInt("dfs.container.ratis.segment.preallocated.size", 0x8000000);
        RaftServerConfigKeys.Log.Appender.setBufferCapacity((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        int maxChunkSize = 0x2000000;
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)0x2000000L));
        TimeUnit timeUnit = OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = conf.getTimeDuration("dfs.ratis.client.request.timeout.duration", OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration clientRequestTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)clientRequestTimeout);
        RaftServerConfigKeys.Log.StateMachineData.setSync((RaftProperties)properties, (boolean)true);
        timeUnit = OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getUnit();
        duration = conf.getTimeDuration("dfs.container.ratis.statemachinedata.sync.timeout", OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getDuration(), timeUnit);
        TimeDuration dataSyncTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeout((RaftProperties)properties, (TimeDuration)dataSyncTimeout);
        timeUnit = OzoneConfigKeys.DFS_RATIS_SERVER_REQUEST_TIMEOUT_DURATION_DEFAULT.getUnit();
        duration = conf.getTimeDuration("dfs.ratis.server.request.timeout.duration", OzoneConfigKeys.DFS_RATIS_SERVER_REQUEST_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration serverRequestTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)serverRequestTimeout);
        timeUnit = OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getUnit();
        duration = conf.getTimeDuration("dfs.ratis.server.retry-cache.timeout.duration", OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
        TimeUnit leaderElectionMinTimeoutUnit = OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getUnit();
        duration = conf.getTimeDuration("dfs.ratis.leader.election.minimum.timeout.duration", OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getDuration(), leaderElectionMinTimeoutUnit);
        TimeDuration leaderElectionMinTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)leaderElectionMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)leaderElectionMinTimeout);
        long leaderElectionMaxTimeout = leaderElectionMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)leaderElectionMaxTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Log.Appender.setBatchEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Log.setMaxCachedSegmentNum((RaftProperties)properties, (int)2);
        timeUnit = OzoneConfigKeys.DFS_RATIS_SERVER_FAILURE_DURATION_DEFAULT.getUnit();
        duration = conf.getTimeDuration("dfs.ratis.server.failure.duration", OzoneConfigKeys.DFS_RATIS_SERVER_FAILURE_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration nodeFailureTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.setLeaderElectionTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        this.nodeFailureTimeoutMs = nodeFailureTimeout.toLong(TimeUnit.MILLISECONDS);
        String storageDir = HddsServerUtil.getOzoneDatanodeRatisDirectory(conf);
        RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(storageDir)));
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)(0x2000000 + raftSegmentPreallocatedSize)));
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        }
        long snapshotThreshold = conf.getLong("dfs.ratis.snapshot.threshold", 10000L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)snapshotThreshold);
        int logQueueSize = conf.getInt("dfs.container.ratis.log.queue.size", 128);
        RaftServerConfigKeys.Log.setQueueSize((RaftProperties)properties, (int)logQueueSize);
        int numSyncRetries = conf.getInt("dfs.container.ratis.statemachinedata.sync.retries", -1);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeoutRetry((RaftProperties)properties, (int)numSyncRetries);
        return properties;
    }

    public static XceiverServerRatis newXceiverServerRatis(DatanodeDetails datanodeDetails, Configuration ozoneConf, ContainerDispatcher dispatcher, StateContext context) throws IOException {
        int localPort = ozoneConf.getInt("dfs.container.ratis.ipc", 9858);
        if (ozoneConf.getBoolean("dfs.container.ratis.ipc.random.port", false)) {
            try (ServerSocket socket = new ServerSocket();){
                socket.setReuseAddress(true);
                InetSocketAddress address = new InetSocketAddress(0);
                socket.bind(address);
                localPort = socket.getLocalPort();
                LOG.info("Found a free port for the server : {}", (Object)localPort);
            }
            catch (IOException e) {
                LOG.error("Unable find a random free port for the server, fallback to use default port {}", (Object)localPort, (Object)e);
            }
        }
        datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.RATIS, (Integer)localPort));
        return new XceiverServerRatis(datanodeDetails, localPort, dispatcher, ozoneConf, context);
    }

    @Override
    public void start() throws IOException {
        LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.getIPCPort()});
        this.chunkExecutor.prestartAllCoreThreads();
        this.server.start();
    }

    @Override
    public void stop() {
        try {
            this.server.close();
            this.chunkExecutor.shutdown();
            this.executors.forEach(ExecutorService::shutdown);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getIPCPort() {
        return this.port;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    private void processReply(RaftClientReply reply) throws IOException {
        NotLeaderException notLeaderException = reply.getNotLeaderException();
        if (notLeaderException != null) {
            throw notLeaderException;
        }
        StateMachineException stateMachineException = reply.getStateMachineException();
        if (stateMachineException != null) {
            throw stateMachineException;
        }
    }

    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        RaftClientReply reply;
        RaftClientRequest raftClientRequest = this.createRaftClientRequest(request, pipelineID, RaftClientRequest.writeRequestType((RaftProtos.ReplicationLevel)this.replicationLevel));
        try {
            reply = (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    private RaftClientRequest createRaftClientRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID, RaftClientRequest.Type type) {
        return new RaftClientRequest(this.clientId, this.server.getId(), PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID).getRaftGroupID(), XceiverServerRatis.nextCallId(), 0L, Message.valueOf((ByteString)request.toByteString()), type);
    }

    private void handlePipelineFailure(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        String msg;
        UUID datanode = RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)roleInfoProto.getSelf());
        RaftPeerId id = RaftPeerId.valueOf((ByteString)roleInfoProto.getSelf().getId());
        switch (roleInfoProto.getRole()) {
            case CANDIDATE: {
                msg = datanode + " is in candidate state for " + roleInfoProto.getCandidateInfo().getLastLeaderElapsedTimeMs() + "ms";
                break;
            }
            case LEADER: {
                StringBuilder sb = new StringBuilder();
                sb.append(datanode).append(" has not seen follower/s");
                for (RaftProtos.ServerRpcProto follower : roleInfoProto.getLeaderInfo().getFollowerInfoList()) {
                    if (follower.getLastRpcElapsedTimeMs() <= this.nodeFailureTimeoutMs) continue;
                    sb.append(" ").append(RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)follower.getId())).append(" for ").append(follower.getLastRpcElapsedTimeMs()).append("ms");
                }
                msg = sb.toString();
                break;
            }
            default: {
                LOG.error("unknown state:" + roleInfoProto.getRole());
                throw new IllegalStateException("node" + id + " is in illegal role " + roleInfoProto.getRole());
            }
        }
        PipelineID pipelineID = PipelineID.valueOf((RaftGroupId)groupId);
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Builder closePipelineInfo = StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(pipelineID.getProtobuf()).setReason(StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED).setDetailedReason(msg);
        StorageContainerDatanodeProtocolProtos.PipelineAction action = StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(closePipelineInfo).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build();
        this.context.addPipelineActionIfAbsent(action);
        LOG.debug("pipeline Action " + (Object)((Object)action.getAction()) + "  on pipeline " + pipelineID + ".Reason : " + action.getClosePipeline().getDetailedReason());
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        try {
            Iterable gids = this.server.getGroupIds();
            ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport> reports = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport>();
            for (RaftGroupId groupId : gids) {
                reports.add(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(PipelineID.valueOf((RaftGroupId)groupId).getProtobuf()).build());
            }
            return reports;
        }
        catch (Exception e) {
            return null;
        }
    }

    void handleNodeSlowness(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(group.getGroupId(), roleInfoProto);
    }

    void handleNoLeader(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(group.getGroupId(), roleInfoProto);
    }
}

