/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.CSMMetrics;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStateMachine
extends BaseStateMachine {
    static final Logger LOG = LoggerFactory.getLogger(ContainerStateMachine.class);
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final RaftGroupId gid;
    private final ContainerDispatcher dispatcher;
    private ThreadPoolExecutor chunkExecutor;
    private final XceiverServerRatis ratisServer;
    private final ConcurrentHashMap<Long, CompletableFuture<Message>> writeChunkFutureMap;
    private final ConcurrentHashMap<Long, Message> createContainerResponseMap;
    private ExecutorService[] executors;
    private final int numExecutors;
    private final Map<Long, Long> applyTransactionCompletionMap;
    private long lastIndex;
    private final CSMMetrics metrics;

    public ContainerStateMachine(RaftGroupId gid, ContainerDispatcher dispatcher, ThreadPoolExecutor chunkExecutor, XceiverServerRatis ratisServer, List<ExecutorService> executors) {
        this.gid = gid;
        this.dispatcher = dispatcher;
        this.chunkExecutor = chunkExecutor;
        this.ratisServer = ratisServer;
        this.metrics = CSMMetrics.create(gid);
        this.numExecutors = executors.size();
        this.executors = executors.toArray(new ExecutorService[this.numExecutors]);
        this.writeChunkFutureMap = new ConcurrentHashMap();
        this.createContainerResponseMap = new ConcurrentHashMap();
        this.applyTransactionCompletionMap = new ConcurrentHashMap<Long, Long>();
        this.lastIndex = -1L;
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    public CSMMetrics getMetrics() {
        return this.metrics;
    }

    public void initialize(RaftServer server, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        super.initialize(server, id, raftStorage);
        this.storage.init(raftStorage);
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    private long loadSnapshot(SingleFileSnapshotInfo snapshot) {
        if (snapshot == null) {
            TermIndex empty = TermIndex.newTermIndex((long)0L, (long)-1L);
            LOG.info("The snapshot info is null.Setting the last applied index to:" + empty);
            this.setLastAppliedTermIndex(empty);
            this.lastIndex = -1L;
            return -1L;
        }
        TermIndex last = SimpleStateMachineStorage.getTermIndexFromSnapshotFile((File)snapshot.getFile().getPath().toFile());
        LOG.info("Setting the last applied index to " + last);
        this.setLastAppliedTermIndex(last);
        this.lastIndex = last.getIndex();
        return last.getIndex();
    }

    public long takeSnapshot() throws IOException {
        TermIndex ti = this.getLastAppliedTermIndex();
        LOG.info("Taking snapshot at termIndex:" + ti);
        if (ti != null) {
            File snapshotFile = this.storage.getSnapshotFile(ti.getTerm(), ti.getIndex());
            LOG.info("Taking a snapshot to file {}", (Object)snapshotFile);
            try {
                snapshotFile.createNewFile();
            }
            catch (IOException ioe) {
                LOG.warn("Failed to write snapshot file \"" + snapshotFile + "\", last applied index=" + ti);
                throw ioe;
            }
            return ti.getIndex();
        }
        return -1L;
    }

    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        ContainerProtos.ContainerCommandRequestProto proto = this.getRequestProto(request.getMessage().getContent());
        Preconditions.checkArgument((boolean)request.getRaftGroupId().equals((Object)this.gid));
        if (proto.getCmdType() == ContainerProtos.Type.WriteChunk) {
            ContainerProtos.WriteChunkRequestProto write = proto.getWriteChunk();
            ContainerProtos.WriteChunkRequestProto dataWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder((ContainerProtos.WriteChunkRequestProto)write).setStage(ContainerProtos.Stage.WRITE_DATA).build();
            ContainerProtos.ContainerCommandRequestProto dataContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)proto).setWriteChunk(dataWriteChunkProto).build();
            ContainerProtos.WriteChunkRequestProto commitWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(write.getBlockID()).setChunkData(write.getChunkData()).setStage(ContainerProtos.Stage.COMMIT_DATA).build();
            ContainerProtos.ContainerCommandRequestProto commitContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)proto).setWriteChunk(commitWriteChunkProto).build();
            return TransactionContext.newBuilder().setClientRequest(request).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setStateMachineData(dataContainerCommandProto.toByteString()).setLogData(commitContainerCommandProto.toByteString()).build();
        }
        if (proto.getCmdType() == ContainerProtos.Type.CreateContainer) {
            return TransactionContext.newBuilder().setClientRequest(request).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setStateMachineData(request.getMessage().getContent()).setLogData(request.getMessage().getContent()).build();
        }
        return TransactionContext.newBuilder().setClientRequest(request).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setLogData(request.getMessage().getContent()).build();
    }

    private ByteString getStateMachineData(RaftProtos.StateMachineLogEntryProto entryProto) {
        return entryProto.getStateMachineEntry().getStateMachineData();
    }

    private ContainerProtos.ContainerCommandRequestProto getRequestProto(ByteString request) throws InvalidProtocolBufferException {
        return ContainerProtos.ContainerCommandRequestProto.parseFrom((ByteString)request);
    }

    private ContainerProtos.ContainerCommandResponseProto dispatchCommand(ContainerProtos.ContainerCommandRequestProto requestProto) {
        LOG.trace("dispatch {}", (Object)requestProto);
        ContainerProtos.ContainerCommandResponseProto response = this.dispatcher.dispatch(requestProto);
        LOG.trace("response {}", (Object)response);
        return response;
    }

    private Message runCommand(ContainerProtos.ContainerCommandRequestProto requestProto) {
        return () -> ((ContainerProtos.ContainerCommandResponseProto)this.dispatchCommand(requestProto)).toByteString();
    }

    private ExecutorService getCommandExecutor(ContainerProtos.ContainerCommandRequestProto requestProto) {
        int executorId = (int)(requestProto.getContainerID() % (long)this.numExecutors);
        return this.executors[executorId];
    }

    private CompletableFuture<Message> handleWriteChunk(ContainerProtos.ContainerCommandRequestProto requestProto, long entryIndex) {
        ContainerProtos.WriteChunkRequestProto write = requestProto.getWriteChunk();
        CompletableFuture<Message> writeChunkFuture = CompletableFuture.supplyAsync(() -> this.runCommand(requestProto), this.chunkExecutor);
        this.writeChunkFutureMap.put(entryIndex, writeChunkFuture);
        LOG.debug("writeChunk writeStateMachineData : blockId " + write.getBlockID() + " logIndex " + entryIndex + " chunkName " + write.getChunkData().getChunkName());
        writeChunkFuture.thenApply(r -> {
            this.writeChunkFutureMap.remove(entryIndex);
            LOG.debug("writeChunk writeStateMachineData  completed: blockId " + write.getBlockID() + " logIndex " + entryIndex + " chunkName " + write.getChunkData().getChunkName());
            return r;
        });
        return writeChunkFuture;
    }

    private CompletableFuture<Message> handleCreateContainer(ContainerProtos.ContainerCommandRequestProto requestProto) {
        long containerID = requestProto.getContainerID();
        Message response = this.runCommand(requestProto);
        this.createContainerResponseMap.put(containerID, response);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<Message> writeStateMachineData(RaftProtos.LogEntryProto entry) {
        try {
            this.metrics.incNumWriteStateMachineOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(this.getStateMachineData(entry.getStateMachineLogEntry()));
            ContainerProtos.Type cmdType = requestProto.getCmdType();
            switch (cmdType) {
                case CreateContainer: {
                    return this.handleCreateContainer(requestProto);
                }
                case WriteChunk: {
                    return this.handleWriteChunk(requestProto, entry.getIndex());
                }
            }
            throw new IllegalStateException("Cmd Type:" + cmdType + " should not have state machine data");
        }
        catch (IOException e) {
            this.metrics.incNumWriteStateMachineFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            this.metrics.incNumReadStateMachineOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(request.getContent());
            return CompletableFuture.completedFuture(this.runCommand(requestProto));
        }
        catch (IOException e) {
            this.metrics.incNumReadStateMachineFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    private ByteString readStateMachineData(ContainerProtos.ContainerCommandRequestProto requestProto) {
        ContainerProtos.WriteChunkRequestProto writeChunkRequestProto = requestProto.getWriteChunk();
        Preconditions.checkArgument((writeChunkRequestProto.getStage() == ContainerProtos.Stage.COMMIT_DATA ? 1 : 0) != 0);
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequestProto = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(writeChunkRequestProto.getBlockID()).setChunkData(writeChunkRequestProto.getChunkData());
        ContainerProtos.ContainerCommandRequestProto dataContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)requestProto).setCmdType(ContainerProtos.Type.ReadChunk).setReadChunk(readChunkRequestProto).build();
        ContainerProtos.ContainerCommandResponseProto response = this.dispatchCommand(dataContainerCommandProto);
        ContainerProtos.ReadChunkResponseProto responseProto = response.getReadChunk();
        Preconditions.checkNotNull((Object)responseProto.getData());
        ContainerProtos.WriteChunkRequestProto.Builder dataWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder((ContainerProtos.WriteChunkRequestProto)writeChunkRequestProto).setData(responseProto.getData()).setStage(ContainerProtos.Stage.WRITE_DATA);
        ContainerProtos.ContainerCommandRequestProto.Builder newStateMachineProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)requestProto).setWriteChunk(dataWriteChunkProto);
        return newStateMachineProto.build().toByteString();
    }

    public CompletableFuture<Void> flushStateMachineData(long index) {
        List<CompletableFuture> futureList = this.writeChunkFutureMap.entrySet().stream().filter(x -> (Long)x.getKey() <= index).map(Map.Entry::getValue).collect(Collectors.toList());
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
    }

    public CompletableFuture<ByteString> readStateMachineData(RaftProtos.LogEntryProto entry) {
        RaftProtos.StateMachineLogEntryProto smLogEntryProto = entry.getStateMachineLogEntry();
        if (!this.getStateMachineData(smLogEntryProto).isEmpty()) {
            return CompletableFuture.completedFuture(ByteString.EMPTY);
        }
        try {
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(entry.getStateMachineLogEntry().getLogData());
            Preconditions.checkArgument((!HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)requestProto) ? 1 : 0) != 0);
            if (requestProto.getCmdType() == ContainerProtos.Type.WriteChunk) {
                return CompletableFuture.supplyAsync(() -> this.readStateMachineData(requestProto), this.chunkExecutor);
            }
            if (requestProto.getCmdType() == ContainerProtos.Type.CreateContainer) {
                return CompletableFuture.completedFuture(requestProto.toByteString());
            }
            throw new IllegalStateException("Cmd type:" + requestProto.getCmdType() + " cannot have state machine data");
        }
        catch (Exception e) {
            LOG.error("unable to read stateMachineData:" + e);
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    private void updateLastApplied() {
        Long removed;
        Long appliedTerm = null;
        long appliedIndex = -1L;
        long i = this.getLastAppliedTermIndex().getIndex() + 1L;
        while ((removed = this.applyTransactionCompletionMap.remove(i)) != null) {
            appliedTerm = removed;
            appliedIndex = i++;
        }
        if (appliedTerm != null) {
            this.updateLastAppliedTermIndex(appliedTerm, appliedIndex);
        }
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        long index = trx.getLogEntry().getIndex();
        for (long i = this.lastIndex + 1L; i < index; ++i) {
            LOG.info("Gap in indexes at:{} detected, adding dummy entries ", (Object)i);
            this.applyTransactionCompletionMap.put(i, trx.getLogEntry().getTerm());
        }
        try {
            CompletableFuture<Message> future;
            this.metrics.incNumApplyTransactionsOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(trx.getStateMachineLogEntry().getLogData());
            ContainerProtos.Type cmdType = requestProto.getCmdType();
            if (cmdType == ContainerProtos.Type.PutBlock) {
                BlockData blockData;
                ContainerProtos.BlockData blockDataProto = requestProto.getPutBlock().getBlockData();
                try {
                    blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockDataProto);
                }
                catch (IOException ioe) {
                    LOG.error("unable to retrieve blockData info for Block {}", (Object)blockDataProto.getBlockID());
                    return ContainerStateMachine.completeExceptionally(ioe);
                }
                blockData.setBlockCommitSequenceId(index);
                ContainerProtos.PutBlockRequestProto putBlockRequestProto = ContainerProtos.PutBlockRequestProto.newBuilder((ContainerProtos.PutBlockRequestProto)requestProto.getPutBlock()).setBlockData(blockData.getProtoBufMessage()).build();
                ContainerProtos.ContainerCommandRequestProto containerCommandRequestProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)requestProto).setPutBlock(putBlockRequestProto).build();
                future = CompletableFuture.supplyAsync(() -> this.runCommand(containerCommandRequestProto), this.getCommandExecutor(requestProto));
            } else if (cmdType == ContainerProtos.Type.CreateContainer) {
                long containerID = requestProto.getContainerID();
                future = CompletableFuture.completedFuture(this.createContainerResponseMap.remove(containerID));
            } else {
                if (cmdType == ContainerProtos.Type.WriteChunk) {
                    Preconditions.checkArgument((boolean)requestProto.getWriteChunk().getData().isEmpty());
                }
                future = CompletableFuture.supplyAsync(() -> this.runCommand(requestProto), this.getCommandExecutor(requestProto));
            }
            this.lastIndex = index;
            future.thenAccept(m -> {
                Long previous = this.applyTransactionCompletionMap.put(index, trx.getLogEntry().getTerm());
                Preconditions.checkState((previous == null ? 1 : 0) != 0);
                this.updateLastApplied();
            });
            return future;
        }
        catch (IOException e) {
            this.metrics.incNumApplyTransactionsFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    public void notifySlowness(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.ratisServer.handleNodeSlowness(group, roleInfoProto);
    }

    public void notifyExtendedNoLeader(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.ratisServer.handleNoLeader(group, roleInfoProto);
    }

    public void close() throws IOException {
    }
}

