/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.ratis.protocol.RaftGroupId;

@InterfaceAudience.Private
@Metrics(about="Container State Machine Metrics", context="dfs")
public class CSMMetrics {
    public static final String SOURCE_NAME = CSMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numWriteStateMachineOps;
    @Metric
    private MutableCounterLong numReadStateMachineOps;
    @Metric
    private MutableCounterLong numApplyTransactionOps;
    @Metric
    private MutableCounterLong numWriteStateMachineFails;
    @Metric
    private MutableCounterLong numReadStateMachineFails;
    @Metric
    private MutableCounterLong numApplyTransactionFails;

    public static CSMMetrics create(RaftGroupId gid) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CSMMetrics)ms.register(SOURCE_NAME + gid.toString(), "Container State Machine", (Object)new CSMMetrics());
    }

    public void incNumWriteStateMachineOps() {
        this.numWriteStateMachineOps.incr();
    }

    public void incNumReadStateMachineOps() {
        this.numReadStateMachineOps.incr();
    }

    public void incNumApplyTransactionsOps() {
        this.numApplyTransactionOps.incr();
    }

    public void incNumWriteStateMachineFails() {
        this.numWriteStateMachineFails.incr();
    }

    public void incNumReadStateMachineFails() {
        this.numReadStateMachineFails.incr();
    }

    public void incNumApplyTransactionsFails() {
        this.numApplyTransactionFails.incr();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineOps() {
        return this.numWriteStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineOps() {
        return this.numReadStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsOps() {
        return this.numApplyTransactionOps.value();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineFails() {
        return this.numWriteStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineFails() {
        return this.numReadStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsFails() {
        return this.numApplyTransactionFails.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

