/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    public static final Logger LOG = LoggerFactory.getLogger(VersionEndpointTask.class);
    private final EndpointStateMachine rpcEndPoint;
    private final Configuration configuration;
    private final OzoneContainer ozoneContainer;

    public VersionEndpointTask(EndpointStateMachine rpcEndPoint, Configuration conf, OzoneContainer container) {
        this.rpcEndPoint = rpcEndPoint;
        this.configuration = conf;
        this.ozoneContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        block14: {
            this.rpcEndPoint.lock();
            try {
                if (this.rpcEndPoint.getState().equals((Object)EndpointStateMachine.EndPointStates.GETVERSION)) {
                    StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto versionResponse = this.rpcEndPoint.getEndPoint().getVersion(null);
                    VersionResponse response = VersionResponse.getFromProtobuf(versionResponse);
                    this.rpcEndPoint.setVersion(response);
                    String scmId = response.getValue("scmUuid");
                    String clusterId = response.getValue("clusterID");
                    VolumeSet volumeSet = this.ozoneContainer.getVolumeSet();
                    volumeSet.writeLock();
                    try {
                        Map<String, HddsVolume> volumeMap = volumeSet.getVolumeMap();
                        Preconditions.checkNotNull((Object)scmId, (Object)"Reply from SCM: scmId cannot be null");
                        Preconditions.checkNotNull((Object)clusterId, (Object)"Reply from SCM: clusterId cannot be null");
                        for (Map.Entry<String, HddsVolume> entry : volumeMap.entrySet()) {
                            HddsVolume hddsVolume = entry.getValue();
                            boolean result = HddsVolumeUtil.checkVolume(hddsVolume, scmId, clusterId, LOG);
                            if (result) continue;
                            volumeSet.failVolume(hddsVolume.getHddsRootDir().getPath());
                        }
                        if (volumeSet.getVolumesList().size() == 0) {
                            throw new DiskChecker.DiskOutOfSpaceException("All configured Volumes are in Inconsistent State");
                        }
                    }
                    finally {
                        volumeSet.writeUnlock();
                    }
                    this.ozoneContainer.getDispatcher().setScmId(scmId);
                    EndpointStateMachine.EndPointStates nextState = this.rpcEndPoint.getState().getNextState();
                    this.rpcEndPoint.setState(nextState);
                    this.rpcEndPoint.zeroMissedCount();
                    break block14;
                }
                LOG.debug("Cannot execute GetVersion task as endpoint state machine is in {} state", (Object)this.rpcEndPoint.getState());
            }
            catch (DiskChecker.DiskOutOfSpaceException ex) {
                this.rpcEndPoint.setState(EndpointStateMachine.EndPointStates.SHUTDOWN);
            }
            catch (IOException ex) {
                this.rpcEndPoint.logIfNeeded(ex);
            }
            finally {
                this.rpcEndPoint.unlock();
            }
        }
        return this.rpcEndPoint.getState();
    }
}

