/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.datanode;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.endpoint.HeartbeatEndpointTask;
import org.apache.hadoop.ozone.container.common.states.endpoint.RegisterEndpointTask;
import org.apache.hadoop.ozone.container.common.states.endpoint.VersionEndpointTask;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningDatanodeState
implements DatanodeState {
    static final Logger LOG = LoggerFactory.getLogger(RunningDatanodeState.class);
    private final SCMConnectionManager connectionManager;
    private final Configuration conf;
    private final StateContext context;
    private CompletionService<EndpointStateMachine.EndPointStates> ecs;

    public RunningDatanodeState(Configuration conf, SCMConnectionManager connectionManager, StateContext context) {
        this.connectionManager = connectionManager;
        this.conf = conf;
        this.context = context;
    }

    @Override
    public void onEnter() {
        LOG.trace("Entering handshake task.");
    }

    @Override
    public void onExit() {
        LOG.trace("Exiting handshake task.");
    }

    @Override
    public void execute(ExecutorService executor) {
        this.ecs = new ExecutorCompletionService<EndpointStateMachine.EndPointStates>(executor);
        for (EndpointStateMachine endpoint : this.connectionManager.getValues()) {
            Callable<EndpointStateMachine.EndPointStates> endpointTask = this.getEndPointTask(endpoint);
            this.ecs.submit(endpointTask);
        }
    }

    private Callable<EndpointStateMachine.EndPointStates> getEndPointTask(EndpointStateMachine endpoint) {
        switch (endpoint.getState()) {
            case GETVERSION: {
                return new VersionEndpointTask(endpoint, this.conf, this.context.getParent().getContainer());
            }
            case REGISTER: {
                return RegisterEndpointTask.newBuilder().setConfig(this.conf).setEndpointStateMachine(endpoint).setContext(this.context).setDatanodeDetails(this.context.getParent().getDatanodeDetails()).setOzoneContainer(this.context.getParent().getContainer()).build();
            }
            case HEARTBEAT: {
                return HeartbeatEndpointTask.newBuilder().setConfig(this.conf).setEndpointStateMachine(endpoint).setDatanodeDetails(this.context.getParent().getDatanodeDetails()).setContext(this.context).build();
            }
            case SHUTDOWN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Argument.");
            }
        }
        return null;
    }

    private DatanodeStateMachine.DatanodeStates computeNextContainerState(List<Future<EndpointStateMachine.EndPointStates>> results) {
        for (Future<EndpointStateMachine.EndPointStates> state : results) {
            try {
                if (state.get() != EndpointStateMachine.EndPointStates.SHUTDOWN) continue;
                return DatanodeStateMachine.DatanodeStates.SHUTDOWN;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Error in executing end point task.", (Throwable)e);
            }
        }
        return DatanodeStateMachine.DatanodeStates.RUNNING;
    }

    public DatanodeStateMachine.DatanodeStates await(long duration, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        int count = this.connectionManager.getValues().size();
        int returned = 0;
        long startTime = Time.monotonicNow();
        LinkedList<Future<EndpointStateMachine.EndPointStates>> results = new LinkedList<Future<EndpointStateMachine.EndPointStates>>();
        for (long timeLeft = timeUnit.toMillis(duration); returned < count && timeLeft > 0L; timeLeft -= Time.monotonicNow() - startTime) {
            Future<EndpointStateMachine.EndPointStates> result = this.ecs.poll(timeLeft, TimeUnit.MILLISECONDS);
            if (result == null) continue;
            results.add(result);
            ++returned;
        }
        return this.computeNextContainerState(results);
    }
}

