/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerCommandHandler
implements CommandHandler {
    static final Logger LOG = LoggerFactory.getLogger(CloseContainerCommandHandler.class);
    private int invocationCount;
    private long totalTime;
    private boolean cmdExecuted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        LOG.debug("Processing Close Container command.");
        ++this.invocationCount;
        this.cmdExecuted = false;
        long startTime = Time.monotonicNow();
        long containerID = -1L;
        try {
            StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeContainerProto = StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto.parseFrom(command.getProtoBufMessage());
            containerID = closeContainerProto.getContainerID();
            if (((ContainerData)container.getContainerSet().getContainer(containerID).getContainerData()).isClosed()) {
                LOG.debug("Container {} is already closed", (Object)containerID);
                this.cmdExecuted = true;
                return;
            }
            HddsProtos.PipelineID pipelineID = closeContainerProto.getPipelineID();
            HddsProtos.ReplicationType replicationType = closeContainerProto.getReplicationType();
            ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
            request.setCmdType(ContainerProtos.Type.CloseContainer);
            request.setContainerID(containerID);
            request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
            request.setTraceID(UUID.randomUUID().toString());
            request.setDatanodeUuid(context.getParent().getDatanodeDetails().getUuidString());
            container.submitContainerRequest(request.build(), replicationType, pipelineID);
        }
        catch (Exception e) {
            if (e instanceof NotLeaderException) {
                context.removeCommandStatus(containerID);
                LOG.info(e.getLocalizedMessage());
            } else {
                LOG.error("Can't close container " + containerID, (Throwable)e);
                this.cmdExecuted = false;
            }
        }
        finally {
            this.updateCommandStatus(context, command, cmdStatus -> cmdStatus.setStatus(this.cmdExecuted), LOG);
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount > 0) {
            return this.totalTime / (long)this.invocationCount;
        }
        return 0L;
    }
}

