/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.InitDatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.RunningDatanodeState;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlockCommandStatus;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateContext {
    static final Logger LOG = LoggerFactory.getLogger(StateContext.class);
    private final Queue<SCMCommand> commandQueue;
    private final Map<Long, CommandStatus> cmdStatusMap;
    private final Lock lock;
    private final DatanodeStateMachine parent;
    private final AtomicLong stateExecutionCount;
    private final Configuration conf;
    private final List<GeneratedMessage> reports;
    private final Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> containerActions;
    private final Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> pipelineActions;
    private DatanodeStateMachine.DatanodeStates state;
    private AtomicLong heartbeatFrequency = new AtomicLong(2000L);

    public StateContext(Configuration conf, DatanodeStateMachine.DatanodeStates state, DatanodeStateMachine parent) {
        this.conf = conf;
        this.state = state;
        this.parent = parent;
        this.commandQueue = new LinkedList<SCMCommand>();
        this.cmdStatusMap = new ConcurrentHashMap<Long, CommandStatus>();
        this.reports = new LinkedList<GeneratedMessage>();
        this.containerActions = new LinkedList<StorageContainerDatanodeProtocolProtos.ContainerAction>();
        this.pipelineActions = new LinkedList<StorageContainerDatanodeProtocolProtos.PipelineAction>();
        this.lock = new ReentrantLock();
        this.stateExecutionCount = new AtomicLong(0L);
    }

    public DatanodeStateMachine getParent() {
        return this.parent;
    }

    public int getContainerPort() {
        return this.parent == null ? -1 : this.parent.getContainer().getContainerServerPort();
    }

    public int getRatisPort() {
        return this.parent == null ? -1 : this.parent.getContainer().getRatisContainerServerPort();
    }

    boolean isEntering() {
        return this.stateExecutionCount.get() == 0L;
    }

    boolean isExiting(DatanodeStateMachine.DatanodeStates newState) {
        boolean isExiting;
        boolean bl = isExiting = this.state != newState && this.stateExecutionCount.get() > 0L;
        if (isExiting) {
            this.stateExecutionCount.set(0L);
        }
        return isExiting;
    }

    public DatanodeStateMachine.DatanodeStates getState() {
        return this.state;
    }

    public void setState(DatanodeStateMachine.DatanodeStates state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReport(GeneratedMessage report) {
        if (report != null) {
            List<GeneratedMessage> list = this.reports;
            synchronized (list) {
                this.reports.add(report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBackReports(List<GeneratedMessage> reportsToPutBack) {
        List<GeneratedMessage> list = this.reports;
        synchronized (list) {
            this.reports.addAll(0, reportsToPutBack);
        }
    }

    public List<GeneratedMessage> getAllAvailableReports() {
        return this.getReports(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeneratedMessage> getReports(int maxLimit) {
        LinkedList<GeneratedMessage> reportsToReturn = new LinkedList<GeneratedMessage>();
        List<GeneratedMessage> list = this.reports;
        synchronized (list) {
            List<GeneratedMessage> tempList = this.reports.subList(0, Math.min(this.reports.size(), maxLimit));
            reportsToReturn.addAll(tempList);
            tempList.clear();
        }
        return reportsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerAction(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> queue = this.containerActions;
        synchronized (queue) {
            this.containerActions.add(containerAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerActionIfAbsent(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> queue = this.containerActions;
        synchronized (queue) {
            if (!this.containerActions.contains(containerAction)) {
                this.containerActions.add(containerAction);
            }
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getAllPendingContainerActions() {
        return this.getPendingContainerAction(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getPendingContainerAction(int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction> containerActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction>();
        Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> queue = this.containerActions;
        synchronized (queue) {
            if (!this.containerActions.isEmpty()) {
                int size = this.containerActions.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    StorageContainerDatanodeProtocolProtos.ContainerAction action = this.containerActions.poll();
                    Preconditions.checkNotNull((Object)action);
                    containerActionList.add(action);
                }
            }
            return containerActionList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPipelineActionIfAbsent(StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction) {
        Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> queue = this.pipelineActions;
        synchronized (queue) {
            for (StorageContainerDatanodeProtocolProtos.PipelineAction pipelineActionIter : this.pipelineActions) {
                if (pipelineActionIter.getAction() != pipelineAction.getAction() || !pipelineActionIter.hasClosePipeline() || !pipelineAction.hasClosePipeline() || !pipelineActionIter.getClosePipeline().getPipelineID().equals((Object)pipelineAction.getClosePipeline().getPipelineID())) continue;
                return;
            }
            this.pipelineActions.add(pipelineAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.PipelineAction> getPendingPipelineAction(int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction> pipelineActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction>();
        Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> queue = this.pipelineActions;
        synchronized (queue) {
            if (!this.pipelineActions.isEmpty()) {
                int size = this.pipelineActions.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    pipelineActionList.add(this.pipelineActions.poll());
                }
            }
            return pipelineActionList;
        }
    }

    public DatanodeState<DatanodeStateMachine.DatanodeStates> getTask() {
        switch (this.state) {
            case INIT: {
                return new InitDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case RUNNING: {
                return new RunningDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case SHUTDOWN: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not Implemented yet.");
    }

    public void execute(ExecutorService service, long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.stateExecutionCount.incrementAndGet();
        DatanodeState<DatanodeStateMachine.DatanodeStates> task = this.getTask();
        if (this.isEntering()) {
            task.onEnter();
        }
        task.execute(service);
        DatanodeStateMachine.DatanodeStates newState = task.await(time, unit);
        if (this.state != newState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Task {} executed, state transited from {} to {}", new Object[]{task.getClass().getSimpleName(), this.state, newState});
            }
            if (this.isExiting(newState)) {
                task.onExit();
            }
            this.setState(newState);
        }
    }

    public SCMCommand getNextCommand() {
        this.lock.lock();
        try {
            SCMCommand sCMCommand = this.commandQueue.poll();
            return sCMCommand;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCommand(SCMCommand command) {
        this.lock.lock();
        try {
            this.commandQueue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.addCmdStatus(command);
    }

    public long getExecutionCount() {
        return this.stateExecutionCount.get();
    }

    public CommandStatus getCmdStatus(Long key) {
        return this.cmdStatusMap.get(key);
    }

    public void addCmdStatus(Long key, CommandStatus status) {
        this.cmdStatusMap.put(key, status);
    }

    public void addCmdStatus(SCMCommand cmd) {
        CommandStatus.CommandStatusBuilder statusBuilder = cmd.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand ? new DeleteBlockCommandStatus.DeleteBlockCommandStatusBuilder() : CommandStatus.CommandStatusBuilder.newBuilder();
        this.addCmdStatus(cmd.getId(), statusBuilder.setCmdId(cmd.getId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING).setType(cmd.getType()).build());
    }

    public Map<Long, CommandStatus> getCommandStatusMap() {
        return this.cmdStatusMap;
    }

    public void removeCommandStatus(Long cmdId) {
        this.cmdStatusMap.remove(cmdId);
    }

    public boolean updateCommandStatus(Long cmdId, Consumer<CommandStatus> cmdStatusUpdater) {
        if (this.cmdStatusMap.containsKey(cmdId)) {
            cmdStatusUpdater.accept(this.cmdStatusMap.get(cmdId));
            return true;
        }
        return false;
    }

    public void configureHeartbeatFrequency() {
        this.heartbeatFrequency.set(HddsServerUtil.getScmHeartbeatInterval(this.conf));
    }

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency.get();
    }
}

