/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueHandler;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;

public abstract class Handler {
    protected final Configuration conf;
    protected final ContainerSet containerSet;
    protected final VolumeSet volumeSet;
    protected String scmID;
    protected final ContainerMetrics metrics;

    protected Handler(Configuration config, ContainerSet contSet, VolumeSet volumeSet, ContainerMetrics containerMetrics) {
        this.conf = config;
        this.containerSet = contSet;
        this.volumeSet = volumeSet;
        this.metrics = containerMetrics;
    }

    public static Handler getHandlerForContainerType(ContainerProtos.ContainerType containerType, Configuration config, ContainerSet contSet, VolumeSet volumeSet, ContainerMetrics metrics) {
        switch (containerType) {
            case KeyValueContainer: {
                return new KeyValueHandler(config, contSet, volumeSet, metrics);
            }
        }
        throw new IllegalArgumentException("Handler for ContainerType: " + containerType + "doesn't exist.");
    }

    public abstract ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto var1, Container var2);

    public abstract Container importContainer(long var1, long var3, FileInputStream var5, TarContainerPacker var6) throws IOException;

    public void setScmID(String scmId) {
        this.scmID = scmId;
    }
}

