/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HddsDispatcher
implements ContainerDispatcher {
    static final Logger LOG = LoggerFactory.getLogger(HddsDispatcher.class);
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private final Configuration conf;
    private final ContainerSet containerSet;
    private final VolumeSet volumeSet;
    private final StateContext context;
    private final float containerCloseThreshold;
    private String scmID;
    private ContainerMetrics metrics;

    public HddsDispatcher(Configuration config, ContainerSet contSet, VolumeSet volumes, StateContext context) {
        this.conf = config;
        this.containerSet = contSet;
        this.volumeSet = volumes;
        this.context = context;
        this.handlers = Maps.newHashMap();
        this.metrics = ContainerMetrics.create(this.conf);
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            this.handlers.put(containerType, Handler.getHandlerForContainerType(containerType, this.conf, this.containerSet, this.volumeSet, this.metrics));
        }
        this.containerCloseThreshold = this.conf.getFloat("hdds.container.close.threshold", 0.9f);
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
        this.volumeSet.shutdown();
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto dispatch(ContainerProtos.ContainerCommandRequestProto msg) {
        Handler handler;
        LOG.trace("Command {}, trace ID: {} ", (Object)msg.getCmdType().toString(), (Object)msg.getTraceID());
        Preconditions.checkNotNull((Object)msg);
        Container container = null;
        ContainerProtos.ContainerType containerType = null;
        ContainerProtos.ContainerCommandResponseProto responseProto = null;
        long startTime = System.nanoTime();
        ContainerProtos.Type cmdType = msg.getCmdType();
        try {
            long containerID = msg.getContainerID();
            this.metrics.incContainerOpsMetrics(cmdType);
            if (cmdType != ContainerProtos.Type.CreateContainer) {
                container = this.getContainer(containerID);
                containerType = this.getContainerType(container);
            } else {
                if (!msg.hasCreateContainer()) {
                    return ContainerUtils.malformedRequest(msg);
                }
                containerType = msg.getCreateContainer().getContainerType();
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, msg);
        }
        if (!HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)msg)) {
            this.sendCloseContainerActionIfNeeded(container);
        }
        if ((handler = this.getHandler(containerType)) == null) {
            StorageContainerException ex = new StorageContainerException("Invalid ContainerType " + containerType, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
            return ContainerUtils.logAndReturnError(LOG, ex, msg);
        }
        responseProto = handler.handle(msg, container);
        if (responseProto != null) {
            this.metrics.incContainerOpsLatencies(cmdType, System.nanoTime() - startTime);
            return responseProto;
        }
        return ContainerUtils.unsupportedRequest(msg);
    }

    private void sendCloseContainerActionIfNeeded(Container container) {
        Object containerData;
        double containerUsedPercentage;
        Boolean isOpen = Optional.ofNullable(container).map(cont -> cont.getContainerState() == ContainerProtos.ContainerLifeCycleState.OPEN).orElse(Boolean.FALSE);
        if (isOpen.booleanValue() && (containerUsedPercentage = (double)(1.0f * (float)((ContainerData)(containerData = container.getContainerData())).getBytesUsed() / (float)((ContainerData)containerData).getMaxSize())) >= (double)this.containerCloseThreshold) {
            StorageContainerDatanodeProtocolProtos.ContainerAction action = StorageContainerDatanodeProtocolProtos.ContainerAction.newBuilder().setContainerID(((ContainerData)containerData).getContainerID()).setAction(StorageContainerDatanodeProtocolProtos.ContainerAction.Action.CLOSE).setReason(StorageContainerDatanodeProtocolProtos.ContainerAction.Reason.CONTAINER_FULL).build();
            this.context.addContainerActionIfAbsent(action);
        }
    }

    @Override
    public Handler getHandler(ContainerProtos.ContainerType containerType) {
        return this.handlers.get(containerType);
    }

    @Override
    public void setScmId(String scmId) {
        Preconditions.checkNotNull((Object)scmId, (Object)"scmId Cannot be null");
        if (this.scmID == null) {
            this.scmID = scmId;
            for (Map.Entry<ContainerProtos.ContainerType, Handler> handlerMap : this.handlers.entrySet()) {
                handlerMap.getValue().setScmID(this.scmID);
            }
        }
    }

    @VisibleForTesting
    public Container getContainer(long containerID) throws StorageContainerException {
        Container container = this.containerSet.getContainer(containerID);
        if (container == null) {
            throw new StorageContainerException("ContainerID " + containerID + " does not exist", ContainerProtos.Result.CONTAINER_NOT_FOUND);
        }
        return container;
    }

    private ContainerProtos.ContainerType getContainerType(Container container) {
        return container.getContainerType();
    }

    @VisibleForTesting
    public void setMetricsForTesting(ContainerMetrics containerMetrics) {
        this.metrics = containerMetrics;
    }
}

