/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HddsDatanodeService
implements ServicePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(HddsDatanodeService.class);
    private OzoneConfiguration conf;
    private DatanodeDetails datanodeDetails;
    private DatanodeStateMachine datanodeStateMachine;
    private List<ServicePlugin> plugins;

    public HddsDatanodeService() {
        this(null);
    }

    public HddsDatanodeService(Configuration conf) {
        this.conf = conf == null ? new OzoneConfiguration() : new OzoneConfiguration(conf);
    }

    public void start(Object service) {
        OzoneConfiguration.activate();
        if (service instanceof Configurable) {
            this.conf = new OzoneConfiguration(((Configurable)service).getConf());
        }
        if (HddsUtils.isHddsEnabled((Configuration)this.conf)) {
            try {
                String hostname = HddsUtils.getHostName((Configuration)this.conf);
                String ip = InetAddress.getByName(hostname).getHostAddress();
                this.datanodeDetails = this.initializeDatanodeDetails();
                this.datanodeDetails.setHostName(hostname);
                this.datanodeDetails.setIpAddress(ip);
                this.datanodeStateMachine = new DatanodeStateMachine(this.datanodeDetails, (Configuration)this.conf);
                this.startPlugins();
                this.datanodeStateMachine.startDaemon();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't start the HDDS datanode plugin", e);
            }
        }
    }

    private DatanodeDetails initializeDatanodeDetails() throws IOException {
        String idFilePath = HddsUtils.getDatanodeIdFilePath((Configuration)this.conf);
        if (idFilePath == null || idFilePath.isEmpty()) {
            LOG.error("A valid file path is needed for config setting {}", (Object)"ozone.scm.datanode.id");
            throw new IllegalArgumentException("ozone.scm.datanode.id must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        if (idFile.exists()) {
            return ContainerUtils.readDatanodeDetailsFrom(idFile);
        }
        String datanodeUuid = UUID.randomUUID().toString();
        return DatanodeDetails.newBuilder().setUuid(datanodeUuid).build();
    }

    private void startPlugins() {
        try {
            this.plugins = this.conf.getInstances("hdds.datanode.plugins", ServicePlugin.class);
        }
        catch (RuntimeException e) {
            String pluginsValue = this.conf.get("hdds.datanode.plugins");
            LOG.error("Unable to load HDDS DataNode plugins. Specified list of plugins: {}", (Object)pluginsValue, (Object)e);
            throw e;
        }
        for (ServicePlugin plugin : this.plugins) {
            try {
                plugin.start((Object)this);
                LOG.info("Started plug-in {}", (Object)plugin);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin {} could not be started", (Object)plugin, (Object)t);
            }
        }
    }

    public OzoneConfiguration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    @VisibleForTesting
    public DatanodeStateMachine getDatanodeStateMachine() {
        return this.datanodeStateMachine;
    }

    public void join() {
        try {
            this.datanodeStateMachine.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public void stop() {
        if (this.plugins != null) {
            for (ServicePlugin plugin : this.plugins) {
                try {
                    plugin.stop();
                    LOG.info("Stopped plug-in {}", (Object)plugin);
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin {} could not be stopped", (Object)plugin, (Object)t);
                }
            }
        }
        if (this.datanodeStateMachine != null) {
            this.datanodeStateMachine.stopDaemon();
        }
    }

    public void close() throws IOException {
        if (this.plugins != null) {
            for (ServicePlugin plugin : this.plugins) {
                try {
                    plugin.close();
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin {} could not be closed", (Object)plugin, (Object)t);
                }
            }
        }
    }

    public static HddsDatanodeService createHddsDatanodeService(Configuration conf) {
        return new HddsDatanodeService(conf);
    }

    public static void main(String[] args) {
        try {
            OzoneConfiguration conf;
            GenericOptionsParser hParser;
            if (DFSUtil.parseHelpArgument((String[])args, (String)"Starts HDDS Datanode", (PrintStream)System.out, (boolean)false)) {
                System.exit(0);
            }
            if (!(hParser = new GenericOptionsParser((Configuration)(conf = new OzoneConfiguration()), args)).isParseSuccessful()) {
                GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
                System.exit(1);
            }
            StringUtils.startupShutdownMessage(HddsDatanodeService.class, (String[])args, (Logger)LOG);
            DefaultMetricsSystem.initialize((String)"HddsDatanode");
            HddsDatanodeService hddsDatanodeService = HddsDatanodeService.createHddsDatanodeService((Configuration)conf);
            hddsDatanodeService.start(null);
            hddsDatanodeService.join();
        }
        catch (Throwable e) {
            LOG.error("Exception in HddsDatanodeService.", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }
}

