/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HddsServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HddsServerUtil.class);

    private HddsServerUtil() {
    }

    public static InetSocketAddress getScmAddressForDataNodes(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address", "ozone.scm.client.address"});
        if (!host.isPresent()) {
            Collection scmAddresses = HddsUtils.getSCMAddresses((Configuration)conf);
            if (scmAddresses.size() > 1) {
                throw new IllegalArgumentException("ozone.scm.names must contain a single hostname. Multiple SCM hosts are currently unsupported");
            }
            host = Optional.of((Object)((InetSocketAddress)scmAddresses.iterator().next()).getHostName());
        }
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address"});
        InetSocketAddress addr = NetUtils.createSocketAddr((String)((String)host.get() + ":" + port.or((Object)9861)));
        return addr;
    }

    public static InetSocketAddress getScmClientBindAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.client.bind.host"});
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.client.address"});
        return NetUtils.createSocketAddr((String)((String)host.or((Object)"0.0.0.0") + ":" + port.or((Object)9860)));
    }

    public static InetSocketAddress getScmBlockClientBindAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.block.client.bind.host"});
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.block.client.address"});
        return NetUtils.createSocketAddr((String)((String)host.or((Object)"0.0.0.0") + ":" + port.or((Object)9863)));
    }

    public static InetSocketAddress getScmDataNodeBindAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.bind.host"});
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address"});
        return NetUtils.createSocketAddr((String)((String)host.or((Object)"0.0.0.0") + ":" + port.or((Object)9861)));
    }

    public static long getScmheartbeatCheckerInterval(Configuration conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.thread.interval", "3s", TimeUnit.MILLISECONDS);
    }

    public static long getScmHeartbeatInterval(Configuration conf) {
        return conf.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public static long getStaleNodeInterval(Configuration conf) {
        long staleNodeIntervalMs = conf.getTimeDuration("ozone.scm.stale.node.interval", "90s", TimeUnit.MILLISECONDS);
        long heartbeatThreadFrequencyMs = HddsServerUtil.getScmheartbeatCheckerInterval(conf);
        long heartbeatIntervalMs = HddsServerUtil.getScmHeartbeatInterval(conf);
        try {
            ServerUtils.sanitizeUserArgs((long)staleNodeIntervalMs, (long)heartbeatThreadFrequencyMs, (long)5L, (long)1000L);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Stale Node Interval is cannot be honored due to mis-configured {}. ex:  {}", (Object)"ozone.scm.heartbeat.thread.interval", (Object)ex);
            throw ex;
        }
        try {
            ServerUtils.sanitizeUserArgs((long)staleNodeIntervalMs, (long)heartbeatIntervalMs, (long)3L, (long)1000L);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Stale Node Interval MS is cannot be honored due to mis-configured {}. ex:  {}", (Object)"hdds.heartbeat.interval", (Object)ex);
            throw ex;
        }
        return staleNodeIntervalMs;
    }

    public static long getDeadNodeInterval(Configuration conf) {
        long staleNodeIntervalMs = HddsServerUtil.getStaleNodeInterval(conf);
        long deadNodeIntervalMs = conf.getTimeDuration("ozone.scm.dead.node.interval", "10m", TimeUnit.MILLISECONDS);
        try {
            ServerUtils.sanitizeUserArgs((long)deadNodeIntervalMs, (long)staleNodeIntervalMs, (long)2L, (long)1000L);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Dead Node Interval MS is cannot be honored due to mis-configured {}. ex:  {}", (Object)"ozone.scm.stale.node.interval", (Object)ex);
            throw ex;
        }
        return deadNodeIntervalMs;
    }

    public static long getScmRpcTimeOutInMilliseconds(Configuration conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-timeout", 1000L, TimeUnit.MILLISECONDS);
    }

    public static int getLogWarnInterval(Configuration conf) {
        return conf.getInt("ozone.scm.heartbeat.log.warn.interval.count", 10);
    }

    public static int getContainerPort(Configuration conf) {
        return conf.getInt("dfs.container.ipc", 9859);
    }

    public static Map<String, ? extends Map<String, InetSocketAddress>> getScmServiceRpcAddresses(Configuration conf) {
        HashMap<String, InetSocketAddress> serviceInstances = new HashMap<String, InetSocketAddress>();
        serviceInstances.put("OzoneScmServiceInstance", HddsServerUtil.getScmAddressForDataNodes(conf));
        HashMap<String, HashMap<String, InetSocketAddress>> services = new HashMap<String, HashMap<String, InetSocketAddress>>();
        services.put("OzoneScmService", serviceInstances);
        return services;
    }

    public static String getOzoneDatanodeRatisDirectory(Configuration conf) {
        String ratisDir = File.separator + "ratis";
        String storageDir = conf.get("dfs.container.ratis.datanode.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = conf.get("ozone.metadata.dirs");
            Preconditions.checkNotNull((Object)storageDir, (Object)"ozone.metadata.dirs cannot be null, Please check your configs.");
            storageDir = storageDir.concat(ratisDir);
            LOG.warn("Storage directory for Ratis is not configured.Mapping Ratis storage under {}. It is a good idea to map this to an SSD disk.", (Object)storageDir);
        }
        return storageDir;
    }
}

