/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockManagerImpl;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.PendingDeleteHandler;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerWatcher;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementCapacity;
import org.apache.hadoop.hdds.scm.container.placement.metrics.ContainerStat;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationActivityStatus;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NewNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.pipelines.PipelineActionEventHandler;
import org.apache.hadoop.hdds.scm.pipelines.PipelineCloseHandler;
import org.apache.hadoop.hdds.scm.pipelines.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.server.SCMBlockProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMChillModeManager;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.hdds.scm.server.SCMStorage;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerHttpServer;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.common.StorageInfo;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RetriableDatanodeEventWatcher;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class StorageContainerManager
extends ServiceRuntimeInfoImpl
implements SCMMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManager.class);
    private static final String USAGE = "Usage: \n ozone scm [genericOptions] [ " + StartupOption.INIT.getName() + " [ " + StartupOption.CLUSTERID.getName() + " <cid> ] ]\n ozone scm [genericOptions] [ " + StartupOption.GENCLUSTERID.getName() + " ]\n ozone scm [ " + StartupOption.HELP.getName() + " ]\n";
    private static SCMMetrics metrics;
    private final SCMDatanodeProtocolServer datanodeProtocolServer;
    private final SCMBlockProtocolServer blockProtocolServer;
    private final SCMClientProtocolServer clientProtocolServer;
    private final NodeManager scmNodeManager;
    private final ContainerManager containerManager;
    private final BlockManager scmBlockManager;
    private final SCMStorage scmStorage;
    private final EventQueue eventQueue;
    private final StorageContainerManagerHttpServer httpServer;
    private final String scmUsername;
    private final Collection<String> scmAdminUsernames;
    private ObjectName scmInfoBeanName;
    private Cache<String, ContainerStat> containerReportCache;
    private final ReplicationManager replicationManager;
    private final LeaseManager<Long> commandWatcherLeaseManager;
    private final ReplicationActivityStatus replicationStatus;
    private final SCMChillModeManager scmChillModeManager;

    private StorageContainerManager(OzoneConfiguration conf) throws IOException {
        int cacheSize = conf.getInt("ozone.scm.db.cache.size.mb", 128);
        StorageContainerManager.initMetrics();
        this.initContainerReportCache(conf);
        this.scmStorage = new SCMStorage(conf);
        if (this.scmStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new SCMException("SCM not initialized.", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        this.eventQueue = new EventQueue();
        this.scmNodeManager = new SCMNodeManager(conf, this.scmStorage.getClusterID(), this, (EventPublisher)this.eventQueue);
        this.containerManager = new SCMContainerManager((Configuration)conf, this.getScmNodeManager(), cacheSize, (EventPublisher)this.eventQueue);
        this.scmBlockManager = new BlockManagerImpl((Configuration)conf, this.getScmNodeManager(), this.containerManager, (EventPublisher)this.eventQueue);
        this.replicationStatus = new ReplicationActivityStatus();
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler(this.containerManager);
        NodeReportHandler nodeReportHandler = new NodeReportHandler(this.scmNodeManager);
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler(this.containerManager.getPipelineSelector());
        CommandStatusReportHandler cmdStatusReportHandler = new CommandStatusReportHandler();
        NewNodeHandler newNodeHandler = new NewNodeHandler(this.scmNodeManager);
        StaleNodeHandler staleNodeHandler = new StaleNodeHandler(this.containerManager.getPipelineSelector());
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler(this.scmNodeManager, this.getContainerManager().getStateManager());
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        PendingDeleteHandler pendingDeleteHandler = new PendingDeleteHandler(this.scmBlockManager.getSCMBlockDeletingService());
        ContainerReportHandler containerReportHandler = new ContainerReportHandler(this.containerManager, this.scmNodeManager, this.replicationStatus);
        this.scmChillModeManager = new SCMChillModeManager((Configuration)conf, this.getContainerManager().getStateManager().getAllContainers(), this.eventQueue);
        PipelineActionEventHandler pipelineActionEventHandler = new PipelineActionEventHandler();
        PipelineCloseHandler pipelineCloseHandler = new PipelineCloseHandler(this.containerManager.getPipelineSelector());
        long watcherTimeout = conf.getTimeDuration("hdds.scm.watcher.timeout", "10m", TimeUnit.MILLISECONDS);
        this.commandWatcherLeaseManager = new LeaseManager("CommandWatcher", watcherTimeout);
        RetriableDatanodeEventWatcher<CommandStatusReportHandler.DeleteBlockStatus> retriableDatanodeEventWatcher = new RetriableDatanodeEventWatcher<CommandStatusReportHandler.DeleteBlockStatus>((Event<CommandForDatanode>)SCMEvents.RETRIABLE_DATANODE_COMMAND, (Event<CommandStatusReportHandler.DeleteBlockStatus>)SCMEvents.DELETE_BLOCK_STATUS, this.commandWatcherLeaseManager);
        retriableDatanodeEventWatcher.start(this.eventQueue);
        SCMContainerPlacementCapacity containerPlacementPolicy = new SCMContainerPlacementCapacity(this.scmNodeManager, (Configuration)conf);
        this.replicationManager = new ReplicationManager(containerPlacementPolicy, this.containerManager.getStateManager(), this.eventQueue, this.commandWatcherLeaseManager);
        CloseContainerWatcher closeContainerWatcher = new CloseContainerWatcher((Event<CloseContainerEventHandler.CloseContainerRetryableReq>)SCMEvents.CLOSE_CONTAINER_RETRYABLE_REQ, SCMEvents.CLOSE_CONTAINER_STATUS, this.commandWatcherLeaseManager, this.containerManager);
        closeContainerWatcher.start(this.eventQueue);
        this.scmAdminUsernames = conf.getTrimmedStringCollection("ozone.administrators");
        this.scmUsername = UserGroupInformation.getCurrentUser().getUserName();
        if (!this.scmAdminUsernames.contains(this.scmUsername)) {
            this.scmAdminUsernames.add(this.scmUsername);
        }
        this.datanodeProtocolServer = new SCMDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue);
        this.blockProtocolServer = new SCMBlockProtocolServer(conf, this);
        this.clientProtocolServer = new SCMClientProtocolServer(conf, this);
        this.httpServer = new StorageContainerManagerHttpServer((Configuration)conf);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.RETRIABLE_DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler(SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler(SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        this.eventQueue.addHandler(SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler(SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler(SCMEvents.CMD_STATUS_REPORT, (EventHandler)cmdStatusReportHandler);
        this.eventQueue.addHandler(SCMEvents.START_REPLICATION, (EventHandler)this.replicationStatus.getReplicationStatusListener());
        this.eventQueue.addHandler(SCMEvents.CHILL_MODE_STATUS, (EventHandler)this.replicationStatus.getChillModeStatusListener());
        this.eventQueue.addHandler(SCMEvents.PENDING_DELETE_STATUS, (EventHandler)pendingDeleteHandler);
        this.eventQueue.addHandler(SCMEvents.DELETE_BLOCK_STATUS, (EventHandler)((DeletedBlockLogImpl)this.scmBlockManager.getDeletedBlockLog()));
        this.eventQueue.addHandler(SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionEventHandler);
        this.eventQueue.addHandler(SCMEvents.PIPELINE_CLOSE, (EventHandler)pipelineCloseHandler);
        this.eventQueue.addHandler(SCMEvents.NODE_REGISTRATION_CONT_REPORT, (EventHandler)this.scmChillModeManager);
        this.eventQueue.addHandler(SCMEvents.CHILL_MODE_STATUS, (EventHandler)((BlockManagerImpl)this.scmBlockManager));
        this.eventQueue.addHandler(SCMEvents.CHILL_MODE_STATUS, (EventHandler)this.clientProtocolServer);
        this.eventQueue.addHandler(SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.registerMXBean();
    }

    public static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    public static RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build();
        DFSUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        return rpcServer;
    }

    public static void main(String[] argv) throws IOException {
        if (DFSUtil.parseHelpArgument((String[])argv, (String)USAGE, (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        try {
            StorageContainerManager scm;
            OzoneConfiguration conf = new OzoneConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            if (!hParser.isParseSuccessful()) {
                System.err.println("USAGE: " + USAGE + "\n");
                GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
                System.exit(1);
            }
            if ((scm = StorageContainerManager.createSCM(hParser.getRemainingArgs(), conf, true)) != null) {
                scm.start();
                scm.join();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to start the StorageContainerManager.", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE + "\n");
    }

    @VisibleForTesting
    public static StorageContainerManager createSCM(String[] args, OzoneConfiguration conf) throws IOException {
        return StorageContainerManager.createSCM(args, conf, false);
    }

    private static StorageContainerManager createSCM(String[] args, OzoneConfiguration conf, boolean printBanner) throws IOException {
        StartupOption startOpt;
        String[] argv;
        String[] stringArray = argv = args == null ? new String[]{} : args;
        if (!HddsUtils.isHddsEnabled((Configuration)conf)) {
            System.err.println("SCM cannot be started in secure mode or when ozone.enabled is set to false");
            System.exit(1);
        }
        if ((startOpt = StorageContainerManager.parseArguments(argv)) == null) {
            StorageContainerManager.printUsage(System.err);
            ExitUtil.terminate((int)1);
            return null;
        }
        switch (startOpt) {
            case INIT: {
                if (printBanner) {
                    StringUtils.startupShutdownMessage(StorageContainerManager.class, (String[])argv, (Logger)LOG);
                }
                ExitUtil.terminate((int)(StorageContainerManager.scmInit(conf) ? 0 : 1));
                return null;
            }
            case GENCLUSTERID: {
                if (printBanner) {
                    StringUtils.startupShutdownMessage(StorageContainerManager.class, (String[])argv, (Logger)LOG);
                }
                System.out.println("Generating new cluster id:");
                System.out.println(StorageInfo.newClusterID());
                ExitUtil.terminate((int)0);
                return null;
            }
            case HELP: {
                StorageContainerManager.printUsage(System.err);
                ExitUtil.terminate((int)0);
                return null;
            }
        }
        if (printBanner) {
            StringUtils.startupShutdownMessage(StorageContainerManager.class, (String[])argv, (Logger)LOG);
        }
        return new StorageContainerManager(conf);
    }

    public static boolean scmInit(OzoneConfiguration conf) throws IOException {
        SCMStorage scmStorage = new SCMStorage(conf);
        Storage.StorageState state = scmStorage.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                String clusterId = StartupOption.INIT.getClusterId();
                if (clusterId != null && !clusterId.isEmpty()) {
                    scmStorage.setClusterId(clusterId);
                }
                scmStorage.initialize();
                System.out.println("SCM initialization succeeded.Current cluster id for sd=" + scmStorage.getStorageDir() + ";cid=" + scmStorage.getClusterID());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        System.out.println("SCM already initialized. Reusing existing cluster id for sd=" + scmStorage.getStorageDir() + ";cid=" + scmStorage.getClusterID());
        return true;
    }

    private static StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        StartupOption startOpt = null;
        if (argsLen == 0) {
            startOpt = StartupOption.REGULAR;
        }
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (StartupOption.INIT.getName().equalsIgnoreCase(cmd)) {
                startOpt = StartupOption.INIT;
                if (argsLen > 3) {
                    return null;
                }
                ++i;
                while (i < argsLen) {
                    if (args[i].equalsIgnoreCase(StartupOption.CLUSTERID.getName())) {
                        if (++i >= argsLen || args[i].isEmpty()) {
                            LOG.error("Must specify a valid cluster ID after the " + StartupOption.CLUSTERID.getName() + " flag");
                            return null;
                        }
                    } else {
                        return null;
                    }
                    startOpt.setClusterId(args[i]);
                    ++i;
                }
                continue;
            }
            if (!StartupOption.GENCLUSTERID.getName().equalsIgnoreCase(cmd)) continue;
            if (argsLen > 1) {
                return null;
            }
            startOpt = StartupOption.GENCLUSTERID;
        }
        return startOpt;
    }

    public static void initMetrics() {
        metrics = SCMMetrics.create();
    }

    public static SCMMetrics getMetrics() {
        return metrics == null ? SCMMetrics.create() : metrics;
    }

    public SCMStorage getScmStorage() {
        return this.scmStorage;
    }

    public SCMDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    public SCMBlockProtocolServer getBlockProtocolServer() {
        return this.blockProtocolServer;
    }

    public SCMClientProtocolServer getClientProtocolServer() {
        return this.clientProtocolServer;
    }

    private void initContainerReportCache(OzoneConfiguration conf) {
        this.containerReportCache = CacheBuilder.newBuilder().expireAfterAccess(Long.MAX_VALUE, TimeUnit.MILLISECONDS).maximumSize(Integer.MAX_VALUE).removalListener((RemovalListener)new RemovalListener<String, ContainerStat>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<String, ContainerStat> removalNotification) {
                Cache cache = StorageContainerManager.this.containerReportCache;
                synchronized (cache) {
                    ContainerStat stat = (ContainerStat)removalNotification.getValue();
                    metrics.decrContainerStat(stat);
                    LOG.debug("Remove expired container stat entry for datanode: {}.", removalNotification.getKey());
                }
            }
        }).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.scmInfoBeanName = HddsUtils.registerWithJmxProperties((String)"StorageContainerManager", (String)"StorageContainerManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.scmInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.scmInfoBeanName);
            this.scmInfoBeanName = null;
        }
    }

    @VisibleForTesting
    public ContainerInfo getContainerInfo(long containerID) throws IOException {
        return this.containerManager.getContainer(containerID);
    }

    @VisibleForTesting
    public InetSocketAddress getClientRpcAddress() {
        return this.getClientProtocolServer().getClientRpcAddress();
    }

    @Override
    public String getClientRpcPort() {
        InetSocketAddress addr = this.getClientRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    @Override
    public String getDatanodeRpcPort() {
        InetSocketAddress addr = this.getDatanodeRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public void start() throws IOException {
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("StorageContainerLocationProtocol RPC server", this.getClientRpcAddress()));
        DefaultMetricsSystem.initialize((String)"StorageContainerManager");
        this.commandWatcherLeaseManager.start();
        this.getClientProtocolServer().start();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmBlockLocationProtocol RPC server", this.getBlockProtocolServer().getBlockRpcAddress()));
        this.getBlockProtocolServer().start();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmDatanodeProtocl RPC server", this.getDatanodeProtocolServer().getDatanodeRpcAddress()));
        this.getDatanodeProtocolServer().start();
        this.httpServer.start();
        this.scmBlockManager.start();
        this.replicationStatus.start();
        this.replicationManager.start();
        this.setStartTime();
    }

    public void stop() {
        try {
            LOG.info("Stopping Replication Activity Status tracker.");
            this.replicationStatus.close();
        }
        catch (Exception ex) {
            LOG.error("Replication Activity Status tracker stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Replication Manager Service.");
            this.replicationManager.stop();
        }
        catch (Exception ex) {
            LOG.error("Replication manager service stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Lease Manager of the command watchers");
            this.commandWatcherLeaseManager.shutdown();
        }
        catch (Exception ex) {
            LOG.error("Lease Manager of the command watchers stop failed");
        }
        try {
            LOG.info("Stopping datanode service RPC server");
            this.getDatanodeProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager datanode RPC stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping block service RPC server");
            this.getBlockProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager blockRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping the StorageContainerLocationProtocol RPC server");
            this.getClientProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager clientRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Storage Container Manager HTTP server.");
            this.httpServer.stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager HTTP server stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Block Manager Service.");
            this.scmBlockManager.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM block manager service stop failed.", (Throwable)ex);
        }
        if (this.containerReportCache != null) {
            this.containerReportCache.invalidateAll();
            this.containerReportCache.cleanUp();
        }
        if (metrics != null) {
            metrics.unRegister();
        }
        this.unregisterMXBean();
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.containerManager});
    }

    public void join() {
        try {
            this.getBlockProtocolServer().join();
            this.getClientProtocolServer().join();
            this.getDatanodeProtocolServer().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public int getNodeCount(HddsProtos.NodeState nodestate) {
        return this.scmNodeManager.getNodeCount(nodestate);
    }

    @VisibleForTesting
    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    @VisibleForTesting
    public NodeManager getScmNodeManager() {
        return this.scmNodeManager;
    }

    @VisibleForTesting
    public BlockManager getScmBlockManager() {
        return this.scmBlockManager;
    }

    public void checkAdminAccess(String remoteUser) throws IOException {
        if (remoteUser != null && !this.scmAdminUsernames.contains(remoteUser)) {
            throw new IOException("Access denied for user " + remoteUser + ". Superuser privilege is required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerReport(String datanodeUuid) {
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            this.containerReportCache.invalidate((Object)datanodeUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerStat getContainerReport(String datanodeUuid) {
        ContainerStat stat = null;
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            stat = (ContainerStat)this.containerReportCache.getIfPresent((Object)datanodeUuid);
        }
        return stat;
    }

    public ConcurrentMap<String, ContainerStat> getContainerReportCache() {
        return this.containerReportCache.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getContainerReport() {
        HashMap<String, String> id2StatMap = new HashMap<String, String>();
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            ConcurrentMap map = this.containerReportCache.asMap();
            for (Map.Entry entry : map.entrySet()) {
                id2StatMap.put((String)entry.getKey(), ((ContainerStat)entry.getValue()).toJsonString());
            }
        }
        return id2StatMap;
    }

    @Override
    public double getChillModeCurrentContainerThreshold() {
        return this.getCurrentContainerThreshold();
    }

    @Override
    public boolean isInChillMode() {
        return this.scmChillModeManager.getInChillMode();
    }

    public EventPublisher getEventQueue() {
        return this.eventQueue;
    }

    public boolean exitChillMode() {
        this.scmChillModeManager.exitChillMode((EventPublisher)this.eventQueue);
        return true;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return this.scmChillModeManager.getCurrentContainerThreshold();
    }

    public static enum StartupOption {
        INIT("--init"),
        CLUSTERID("--clusterid"),
        GENCLUSTERID("--genclusterid"),
        REGULAR("--regular"),
        HELP("-help");

        private final String name;
        private String clusterId = null;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String cid) {
            if (cid != null && !cid.isEmpty()) {
                this.clusterId = cid;
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

