/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolServerSideTranslatorPB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMDatanodeProtocolServer
implements StorageContainerDatanodeProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(SCMDatanodeProtocolServer.class);
    private final RPC.Server datanodeRpcServer;
    private final StorageContainerManager scm;
    private final InetSocketAddress datanodeRpcAddress;
    private final SCMDatanodeHeartbeatDispatcher heartbeatDispatcher;
    private final EventPublisher eventPublisher;

    public SCMDatanodeProtocolServer(OzoneConfiguration conf, StorageContainerManager scm, EventPublisher eventPublisher) throws IOException {
        Preconditions.checkNotNull((Object)scm, (Object)"SCM cannot be null");
        Preconditions.checkNotNull((Object)eventPublisher, (Object)"EventPublisher cannot be null");
        this.scm = scm;
        this.eventPublisher = eventPublisher;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 10);
        this.heartbeatDispatcher = new SCMDatanodeHeartbeatDispatcher(scm.getScmNodeManager(), eventPublisher);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService dnProtoPbService = StorageContainerDatanodeProtocolProtos.StorageContainerDatanodeProtocolService.newReflectiveBlockingService((StorageContainerDatanodeProtocolProtos.StorageContainerDatanodeProtocolService.BlockingInterface)new StorageContainerDatanodeProtocolServerSideTranslatorPB((StorageContainerDatanodeProtocol)this));
        InetSocketAddress datanodeRpcAddr = HddsServerUtil.getScmDataNodeBindAddress((Configuration)conf);
        this.datanodeRpcServer = StorageContainerManager.startRpcServer(conf, datanodeRpcAddr, StorageContainerDatanodeProtocolPB.class, dnProtoPbService, handlerCount);
        this.datanodeRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)"ozone.scm.datanode.address", (InetSocketAddress)datanodeRpcAddr, (RPC.Server)this.datanodeRpcServer);
    }

    public void start() {
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for DataNodes", this.datanodeRpcAddress));
        this.datanodeRpcServer.start();
    }

    public InetSocketAddress getDatanodeRpcAddress() {
        return this.datanodeRpcAddress;
    }

    public StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto getVersion(StorageContainerDatanodeProtocolProtos.SCMVersionRequestProto versionRequest) throws IOException {
        return this.scm.getScmNodeManager().getVersion(versionRequest).getProtobufMessage();
    }

    public StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto register(HddsProtos.DatanodeDetailsProto datanodeDetailsProto, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReportsProto, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto) throws IOException {
        DatanodeDetails datanodeDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanodeDetailsProto);
        RegisteredCommand registeredCommand = this.scm.getScmNodeManager().register(datanodeDetails, nodeReport, pipelineReportsProto);
        if (registeredCommand.getError() == StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.success) {
            this.scm.getContainerManager().processContainerReports(datanodeDetails, containerReportsProto, true);
            this.eventPublisher.fireEvent(SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)new NodeRegistrationContainerReport(datanodeDetails, containerReportsProto));
            this.eventPublisher.fireEvent(SCMEvents.PIPELINE_REPORT, (Object)new SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode(datanodeDetails, pipelineReportsProto));
        }
        return SCMDatanodeProtocolServer.getRegisteredResponse(registeredCommand);
    }

    @VisibleForTesting
    public static StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto getRegisteredResponse(RegisteredCommand cmd) {
        return StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.newBuilder().setErrorCode(cmd.getError()).setClusterID(cmd.getClusterID()).setDatanodeUUID(cmd.getDatanodeUUID()).build();
    }

    public StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto sendHeartbeat(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat) throws IOException {
        LinkedList<StorageContainerDatanodeProtocolProtos.SCMCommandProto> cmdResponses = new LinkedList<StorageContainerDatanodeProtocolProtos.SCMCommandProto>();
        for (SCMCommand cmd : this.heartbeatDispatcher.dispatch(heartbeat)) {
            cmdResponses.add(this.getCommandResponse(cmd));
        }
        return StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto.newBuilder().setDatanodeUUID(heartbeat.getDatanodeDetails().getUuid()).addAllCommands(cmdResponses).build();
    }

    @VisibleForTesting
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto getCommandResponse(SCMCommand cmd) throws IOException {
        StorageContainerDatanodeProtocolProtos.SCMCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.SCMCommandProto.newBuilder();
        switch (cmd.getType()) {
            case reregisterCommand: {
                return builder.setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reregisterCommand).setReregisterCommandProto(StorageContainerDatanodeProtocolProtos.ReregisterCommandProto.getDefaultInstance()).build();
            }
            case deleteBlocksCommand: {
                List<Long> txs = ((DeleteBlocksCommand)cmd).blocksTobeDeleted().stream().map(tx -> tx.getTxID()).collect(Collectors.toList());
                this.scm.getScmBlockManager().getDeletedBlockLog().incrementCount(txs);
                return builder.setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand).setDeleteBlocksCommandProto(((DeleteBlocksCommand)cmd).getProto()).build();
            }
            case closeContainerCommand: {
                return builder.setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand).setCloseContainerCommandProto(((CloseContainerCommand)cmd).getProto()).build();
            }
            case replicateContainerCommand: {
                return builder.setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand).setReplicateContainerCommandProto(((ReplicateContainerCommand)cmd).getProto()).build();
            }
        }
        throw new IllegalArgumentException("Not implemented");
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for DataNodes");
        this.datanodeRpcServer.join();
    }

    public void stop() {
        try {
            LOG.info("Stopping the RPC server for DataNodes");
            this.datanodeRpcServer.stop();
        }
        catch (Exception ex) {
            LOG.error(" datanodeRpcServer stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public static class NodeRegistrationContainerReport
    extends SCMDatanodeHeartbeatDispatcher.ReportFromDatanode<StorageContainerDatanodeProtocolProtos.ContainerReportsProto> {
        public NodeRegistrationContainerReport(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReportsProto report) {
            super(datanodeDetails, report);
        }
    }
}

