/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ReregisterCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMDatanodeHeartbeatDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SCMDatanodeHeartbeatDispatcher.class);
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;

    public SCMDatanodeHeartbeatDispatcher(NodeManager nodeManager, EventPublisher eventPublisher) {
        Preconditions.checkNotNull((Object)nodeManager);
        Preconditions.checkNotNull((Object)eventPublisher);
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
    }

    public List<SCMCommand> dispatch(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat) {
        List<SCMCommand> commands;
        DatanodeDetails datanodeDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)heartbeat.getDatanodeDetails());
        if (!this.nodeManager.isNodeRegistered(datanodeDetails).booleanValue()) {
            LOG.info("SCM received heartbeat from an unregistered datanode {}. Asking datanode to re-register.", (Object)datanodeDetails);
            UUID dnID = datanodeDetails.getUuid();
            this.nodeManager.addDatanodeCommand(dnID, (SCMCommand)new ReregisterCommand());
            commands = this.nodeManager.getCommandQueue(dnID);
        } else {
            commands = this.nodeManager.processHeartbeat(datanodeDetails);
            if (heartbeat.hasNodeReport()) {
                LOG.debug("Dispatching Node Report.");
                this.eventPublisher.fireEvent(SCMEvents.NODE_REPORT, (Object)new NodeReportFromDatanode(datanodeDetails, heartbeat.getNodeReport()));
            }
            if (heartbeat.hasContainerReport()) {
                LOG.debug("Dispatching Container Report.");
                this.eventPublisher.fireEvent(SCMEvents.CONTAINER_REPORT, (Object)new ContainerReportFromDatanode(datanodeDetails, heartbeat.getContainerReport()));
            }
            if (heartbeat.hasContainerActions()) {
                LOG.debug("Dispatching Container Actions.");
                this.eventPublisher.fireEvent(SCMEvents.CONTAINER_ACTIONS, (Object)new ContainerActionsFromDatanode(datanodeDetails, heartbeat.getContainerActions()));
            }
            if (heartbeat.hasPipelineReports()) {
                LOG.debug("Dispatching Pipeline Report.");
                this.eventPublisher.fireEvent(SCMEvents.PIPELINE_REPORT, (Object)new PipelineReportFromDatanode(datanodeDetails, heartbeat.getPipelineReports()));
            }
            if (heartbeat.hasPipelineActions()) {
                LOG.debug("Dispatching Pipeline Actions.");
                this.eventPublisher.fireEvent(SCMEvents.PIPELINE_ACTIONS, (Object)new PipelineActionsFromDatanode(datanodeDetails, heartbeat.getPipelineActions()));
            }
            if (heartbeat.getCommandStatusReportsCount() != 0) {
                for (StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto commandStatusReport : heartbeat.getCommandStatusReportsList()) {
                    this.eventPublisher.fireEvent(SCMEvents.CMD_STATUS_REPORT, (Object)new CommandStatusReportFromDatanode(datanodeDetails, commandStatusReport));
                }
            }
        }
        return commands;
    }

    public static class CommandStatusReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto> {
        public CommandStatusReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class PipelineActionsFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.PipelineActionsProto> {
        public PipelineActionsFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.PipelineActionsProto actions) {
            super(datanodeDetails, actions);
        }
    }

    public static class PipelineReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.PipelineReportsProto> {
        public PipelineReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.PipelineReportsProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class ContainerActionsFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.ContainerActionsProto> {
        public ContainerActionsFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerActionsProto actions) {
            super(datanodeDetails, actions);
        }
    }

    public static class ContainerReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.ContainerReportsProto> {
        public ContainerReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReportsProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class NodeReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.NodeReportProto> {
        public NodeReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class ReportFromDatanode<T extends GeneratedMessage> {
        private final DatanodeDetails datanodeDetails;
        private final T report;

        public ReportFromDatanode(DatanodeDetails datanodeDetails, T report) {
            this.datanodeDetails = datanodeDetails;
            this.report = report;
        }

        public DatanodeDetails getDatanodeDetails() {
            return this.datanodeDetails;
        }

        public T getReport() {
            return this.report;
        }
    }
}

