/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.ChillModePrecheck;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.protocolPB.StorageContainerLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMClientProtocolServer
implements StorageContainerLocationProtocol,
EventHandler<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private final RPC.Server clientRpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final StorageContainerManager scm;
    private final OzoneConfiguration conf;
    private ChillModePrecheck chillModePrecheck = new ChillModePrecheck();

    public SCMClientProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.conf = conf;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 10);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService storageProtoPbService = StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.newReflectiveBlockingService((StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.BlockingInterface)new StorageContainerLocationProtocolServerSideTranslatorPB((StorageContainerLocationProtocol)this));
        InetSocketAddress scmAddress = HddsServerUtil.getScmClientBindAddress((Configuration)conf);
        this.clientRpcServer = StorageContainerManager.startRpcServer(conf, scmAddress, StorageContainerLocationProtocolPB.class, storageProtoPbService, handlerCount);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)"ozone.scm.client.address", (InetSocketAddress)scmAddress, (RPC.Server)this.clientRpcServer);
    }

    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }

    public void start() {
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Client ", this.getClientRpcAddress()));
        this.getClientRpcServer().start();
    }

    public void stop() {
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    @VisibleForTesting
    public String getRpcRemoteUsername() {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        return user == null ? null : user.getUserName();
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ScmUtils.preCheck(HddsProtos.ScmOps.allocateContainer, this.chillModePrecheck);
        String remoteUser = this.getRpcRemoteUsername();
        this.getScm().checkAdminAccess(remoteUser);
        return this.scm.getContainerManager().allocateContainer(replicationType, factor, owner);
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        String remoteUser = this.getRpcRemoteUsername();
        this.getScm().checkAdminAccess(remoteUser);
        return this.scm.getContainerManager().getContainer(containerID);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        ContainerInfo contInfo;
        if (this.chillModePrecheck.isInChillMode() && (contInfo = this.scm.getContainerManager().getContainer(containerID)).isContainerOpen() && !this.hasRequiredReplicas(contInfo)) {
            throw new SCMException("Open container " + containerID + " doesn't have enough replicas to service this operation in Chill mode.", SCMException.ResultCodes.CHILL_MODE_EXCEPTION);
        }
        this.getScm().checkAdminAccess(null);
        return this.scm.getContainerManager().getContainerWithPipeline(containerID);
    }

    private boolean hasRequiredReplicas(ContainerInfo contInfo) {
        try {
            return this.getScm().getContainerManager().getStateManager().getContainerReplicas(contInfo.containerID()).size() >= contInfo.getReplicationFactor().getNumber();
        }
        catch (SCMException ex) {
            return false;
        }
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.scm.getContainerManager().listContainer(startContainerID, count);
    }

    public void deleteContainer(long containerID) throws IOException {
        String remoteUser = this.getRpcRemoteUsername();
        this.getScm().checkAdminAccess(remoteUser);
        this.scm.getContainerManager().deleteContainer(containerID);
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState state, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        if (queryScope == HddsProtos.QueryScope.POOL) {
            throw new IllegalArgumentException("Not Supported yet");
        }
        ArrayList<HddsProtos.Node> result = new ArrayList<HddsProtos.Node>();
        this.queryNode(state).forEach(node -> result.add(HddsProtos.Node.newBuilder().setNodeID(node.getProtoBufMessage()).addNodeStates(state).build()));
        return result;
    }

    public void notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type type, long id, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op op, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage stage) throws IOException {
        LOG.info("Object type {} id {} op {} new stage {}", new Object[]{type, id, op, stage});
        if (type == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container) {
            if (op == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.create) {
                if (stage == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.begin) {
                    this.scm.getContainerManager().updateContainerState(id, HddsProtos.LifeCycleEvent.CREATE);
                } else {
                    this.scm.getContainerManager().updateContainerState(id, HddsProtos.LifeCycleEvent.CREATED);
                }
            } else if (op == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.close) {
                if (stage == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.begin) {
                    this.scm.getContainerManager().updateContainerState(id, HddsProtos.LifeCycleEvent.FINALIZE);
                } else {
                    this.scm.getContainerManager().updateContainerState(id, HddsProtos.LifeCycleEvent.CLOSE);
                }
            }
        }
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return null;
    }

    public List<Pipeline> listPipelines() {
        return this.scm.getContainerManager().getPipelineSelector().listPipelines();
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        PipelineID id = PipelineID.valueOf((UUID)UUID.fromString(pipelineID.getId()));
        this.scm.getContainerManager().getPipelineSelector().closePipeline(id);
    }

    public ScmInfo getScmInfo() throws IOException {
        ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorage().getClusterID()).setScmId(this.scm.getScmStorage().getScmId());
        return builder.build();
    }

    public boolean inChillMode() throws IOException {
        return this.scm.isInChillMode();
    }

    public boolean forceExitChillMode() throws IOException {
        return this.scm.exitChillMode();
    }

    public List<DatanodeDetails> queryNode(HddsProtos.NodeState state) {
        Preconditions.checkNotNull((Object)state, (Object)"Node Query set cannot be null");
        return new LinkedList<DatanodeDetails>(this.queryNodeState(state));
    }

    @VisibleForTesting
    public StorageContainerManager getScm() {
        return this.scm;
    }

    public void onMessage(Boolean inChillMOde, EventPublisher publisher) {
        this.chillModePrecheck.setInChillMode(inChillMOde);
    }

    public boolean getChillModeStatus() {
        return this.chillModePrecheck.isInChillMode();
    }

    private Set<DatanodeDetails> queryNodeState(HddsProtos.NodeState nodeState) {
        TreeSet<DatanodeDetails> returnSet = new TreeSet<DatanodeDetails>();
        List<DatanodeDetails> tmp = this.scm.getScmNodeManager().getNodes(nodeState);
        if (tmp != null && tmp.size() > 0) {
            returnSet.addAll(tmp);
        }
        return returnSet;
    }
}

