/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.server.Precheck;
import org.apache.hadoop.hdds.scm.server.SCMChillModeManager;

public class ChillModePrecheck
implements Precheck<HddsProtos.ScmOps> {
    private AtomicBoolean inChillMode = new AtomicBoolean(true);
    public static final String PRECHECK_TYPE = "ChillModePrecheck";

    @Override
    public boolean check(HddsProtos.ScmOps op) throws SCMException {
        if (this.inChillMode.get() && SCMChillModeManager.ChillModeRestrictedOps.isRestrictedInChillMode(op)) {
            throw new SCMException("ChillModePrecheck failed for " + op, SCMException.ResultCodes.CHILL_MODE_EXCEPTION);
        }
        return this.inChillMode.get();
    }

    @Override
    public String type() {
        return PRECHECK_TYPE;
    }

    public boolean isInChillMode() {
        return this.inChillMode.get();
    }

    public void setInChillMode(boolean inChillMode) {
        this.inChillMode.set(inChillMode);
    }
}

