/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines.ratis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientRatis;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipelines.PipelineManager;
import org.apache.hadoop.hdds.scm.pipelines.PipelineSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisManagerImpl
extends PipelineManager {
    private static final Logger LOG = LoggerFactory.getLogger(RatisManagerImpl.class);
    private final Configuration conf;
    private final NodeManager nodeManager;
    private final Set<DatanodeDetails> ratisMembers;

    public RatisManagerImpl(NodeManager nodeManager, ContainerPlacementPolicy placementPolicy, long size, Configuration conf) {
        this.conf = conf;
        this.nodeManager = nodeManager;
        this.ratisMembers = new HashSet<DatanodeDetails>();
    }

    @Override
    public Pipeline allocatePipeline(HddsProtos.ReplicationFactor factor) {
        LinkedList<DatanodeDetails> newNodesList = new LinkedList<DatanodeDetails>();
        List<DatanodeDetails> datanodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        for (DatanodeDetails datanode : datanodes) {
            Preconditions.checkNotNull((Object)datanode);
            if (this.ratisMembers.contains(datanode)) continue;
            newNodesList.add(datanode);
            if (newNodesList.size() != factor.getNumber()) continue;
            this.ratisMembers.addAll(newNodesList);
            PipelineID pipelineID = PipelineID.randomId();
            LOG.info("Allocating a new ratis pipeline of size: {} id: {}", (Object)factor.getNumber(), (Object)pipelineID);
            return PipelineSelector.newPipelineFromNodes(newNodesList, HddsProtos.ReplicationType.RATIS, factor, pipelineID);
        }
        return null;
    }

    @Override
    public void initializePipeline(Pipeline pipeline) throws IOException {
        try (XceiverClientRatis client = XceiverClientRatis.newXceiverClientRatis((Pipeline)pipeline, (Configuration)this.conf);){
            client.createPipeline();
        }
    }

    @Override
    public void processPipelineReport(Pipeline pipeline, DatanodeDetails dn) {
        super.processPipelineReport(pipeline, dn);
        this.ratisMembers.add(dn);
    }

    @Override
    public synchronized boolean finalizePipeline(Pipeline pipeline) {
        ((PipelineManager.ActivePipelines)this.activePipelines.get(pipeline.getFactor().ordinal())).removePipeline(pipeline.getId());
        return true;
    }

    @Override
    public void closePipeline(Pipeline pipeline) throws IOException {
        try (XceiverClientRatis client = XceiverClientRatis.newXceiverClientRatis((Pipeline)pipeline, (Configuration)this.conf);){
            client.destroyPipeline();
        }
        for (DatanodeDetails node : pipeline.getMachines()) {
            Preconditions.checkArgument((boolean)this.ratisMembers.remove(node));
        }
    }
}

