/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipelines;

import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.pipelines.PipelineSelector;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineCloseHandler
implements EventHandler<PipelineID> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineCloseHandler.class);
    private final PipelineSelector pipelineSelector;

    public PipelineCloseHandler(PipelineSelector pipelineSelector) {
        this.pipelineSelector = pipelineSelector;
    }

    public void onMessage(PipelineID pipelineID, EventPublisher publisher) {
        Pipeline pipeline = this.pipelineSelector.getPipeline(pipelineID);
        try {
            if (pipeline != null) {
                this.pipelineSelector.finalizePipeline(pipeline);
            } else {
                LOG.debug("pipeline:{} not found", (Object)pipelineID);
            }
        }
        catch (Exception e) {
            LOG.info("failed to close pipeline:{}", (Object)pipelineID, (Object)e);
        }
    }
}

