/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineFactory;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.MetadataStoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMPipelineManager
implements PipelineManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMPipelineManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final PipelineFactory pipelineFactory;
    private final PipelineStateManager stateManager;
    private final MetadataStore pipelineStore;

    public SCMPipelineManager(Configuration conf, NodeManager nodeManager) throws IOException {
        this.stateManager = new PipelineStateManager(conf);
        this.pipelineFactory = new PipelineFactory(nodeManager, this.stateManager);
        int cacheSize = conf.getInt("ozone.scm.db.cache.size.mb", 128);
        File metaDir = ServerUtils.getOzoneMetaDirPath((Configuration)conf);
        File pipelineDBPath = new File(metaDir, "scm-pipeline.db");
        this.pipelineStore = MetadataStoreBuilder.newBuilder().setConf(conf).setDbFile(pipelineDBPath).setCacheSize((long)cacheSize * 0x100000L).build();
        this.initializePipelineState();
    }

    private void initializePipelineState() throws IOException {
        if (this.pipelineStore.isEmpty()) {
            LOG.info("No pipeline exists in current db");
            return;
        }
        List pipelines = this.pipelineStore.getSequentialRangeKVs(null, Integer.MAX_VALUE, null);
        for (Map.Entry entry : pipelines) {
            Pipeline pipeline = Pipeline.fromProtobuf((HddsProtos.Pipeline)((HddsProtos.Pipeline)HddsProtos.Pipeline.PARSER.parseFrom((byte[])entry.getValue())));
            Preconditions.checkNotNull((Object)pipeline);
            this.stateManager.addPipeline(pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pipeline createPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) throws IOException {
        this.lock.writeLock().lock();
        try {
            Pipeline pipeline = this.pipelineFactory.create(type, factor);
            this.stateManager.addPipeline(pipeline);
            try {
                this.pipelineStore.put(pipeline.getID().getProtobuf().toByteArray(), pipeline.getProtobufMessage().toByteArray());
            }
            catch (IOException ioe) {
                this.stateManager.removePipeline(pipeline.getID());
                throw ioe;
            }
            Pipeline pipeline2 = pipeline;
            return pipeline2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline createPipeline(HddsProtos.ReplicationType type, List<DatanodeDetails> nodes) throws IOException {
        this.lock.writeLock().lock();
        try {
            Pipeline pipeline = this.pipelineFactory.create(type, nodes);
            return pipeline;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Pipeline getPipeline(PipelineID pipelineID) throws IOException {
        this.lock.readLock().lock();
        try {
            Pipeline pipeline = this.stateManager.getPipeline(pipelineID);
            return pipeline;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addContainerToPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.stateManager.addContainerToPipeline(pipelineID, containerID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeContainerFromPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.stateManager.removeContainerFromPipeline(pipelineID, containerID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<ContainerID> getContainersInPipeline(PipelineID pipelineID) throws IOException {
        this.lock.readLock().lock();
        try {
            Set<ContainerID> set = this.stateManager.getContainers(pipelineID);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void finalizePipeline(PipelineID pipelineId) throws IOException {
        this.lock.writeLock().lock();
        try {
            Pipeline pipeline = this.stateManager.updatePipelineState(pipelineId, HddsProtos.LifeCycleEvent.FINALIZE);
            this.pipelineStore.put(pipeline.getID().getProtobuf().toByteArray(), pipeline.getProtobufMessage().toByteArray());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void closePipeline(PipelineID pipelineId) throws IOException {
        this.lock.writeLock().lock();
        try {
            Pipeline pipeline = this.stateManager.updatePipelineState(pipelineId, HddsProtos.LifeCycleEvent.CLOSE);
            this.pipelineStore.put(pipeline.getID().getProtobuf().toByteArray(), pipeline.getProtobufMessage().toByteArray());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removePipeline(PipelineID pipelineID) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.stateManager.removePipeline(pipelineID);
            this.pipelineStore.delete(pipelineID.getProtobuf().toByteArray());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            this.stateManager.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

