/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;

public class RatisPipelineProvider
implements PipelineProvider {
    private final NodeManager nodeManager;
    private final PipelineStateManager stateManager;

    RatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        this.nodeManager = nodeManager;
        this.stateManager = stateManager;
    }

    private static ContainerPlacementPolicy createContainerPlacementPolicy(NodeManager nodeManager, Configuration conf) {
        Class implClass = conf.getClass("ozone.scm.container.placement.impl", SCMContainerPlacementRandom.class);
        try {
            Constructor ctor = implClass.getDeclaredConstructor(NodeManager.class, Configuration.class);
            return (ContainerPlacementPolicy)ctor.newInstance(nodeManager, conf);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(implClass.getName() + " could not be constructed.", e.getCause());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load ContainerPlacementPolicy", e);
        }
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor) throws IOException {
        HashSet dnsUsed = new HashSet();
        this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS).forEach(p -> dnsUsed.addAll(p.getNodes()));
        List dns = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).parallelStream().filter(dn -> !dnsUsed.contains(dn)).limit(factor.getNumber()).collect(Collectors.toList());
        if (dns.size() < factor.getNumber()) {
            String e = String.format("Cannot create pipeline of factor %d using %d nodes.", factor.getNumber(), dns.size());
            throw new IOException(e);
        }
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(HddsProtos.LifeCycleState.ALLOCATED).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(dns).build();
    }

    @Override
    public Pipeline create(List<DatanodeDetails> nodes) throws IOException {
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.valueOf((int)nodes.size());
        if (factor == null) {
            throw new IOException(String.format("Nodes size=%d does not match any replication factor", nodes.size()));
        }
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(HddsProtos.LifeCycleState.ALLOCATED).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(nodes).build();
    }
}

