/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineStateMap {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineStateMap.class);
    private final Map<PipelineID, Pipeline> pipelineMap = new HashMap<PipelineID, Pipeline>();
    private final Map<PipelineID, Set<ContainerID>> pipeline2container = new HashMap<PipelineID, Set<ContainerID>>();

    PipelineStateMap() {
    }

    void addPipeline(Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull((Object)pipeline, (Object)"Pipeline cannot be null");
        Preconditions.checkArgument((pipeline.getNodes().size() == pipeline.getFactor().getNumber() ? 1 : 0) != 0, (Object)String.format("Nodes size=%d, replication factor=%d do not match ", pipeline.getNodes().size(), pipeline.getFactor().getNumber()));
        if (this.pipelineMap.putIfAbsent(pipeline.getID(), pipeline) != null) {
            LOG.warn("Duplicate pipeline ID detected. {}", (Object)pipeline.getID());
            throw new IOException(String.format("Duplicate pipeline ID %s detected.", pipeline.getID()));
        }
        this.pipeline2container.put(pipeline.getID(), new TreeSet());
    }

    void addContainerToPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        Preconditions.checkNotNull((Object)pipelineID, (Object)"Pipeline Id cannot be null");
        Preconditions.checkNotNull((Object)containerID, (Object)"container Id cannot be null");
        Pipeline pipeline = this.getPipeline(pipelineID);
        if (!this.isOpen(pipeline)) {
            throw new IOException(String.format("%s is not in open state", pipelineID));
        }
        this.pipeline2container.get(pipelineID).add(containerID);
    }

    Pipeline getPipeline(PipelineID pipelineID) throws IOException {
        Pipeline pipeline = this.pipelineMap.get(pipelineID);
        if (pipeline == null) {
            throw new IOException(String.format("%s not found", pipelineID));
        }
        return pipeline;
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Replication type cannot be null");
        return this.pipelineMap.values().stream().filter(p -> p.getType().equals((Object)type)).collect(Collectors.toList());
    }

    Set<ContainerID> getContainers(PipelineID pipelineID) throws IOException {
        Set<ContainerID> containerIDs = this.pipeline2container.get(pipelineID);
        if (containerIDs == null) {
            throw new IOException(String.format("%s not found", pipelineID));
        }
        return new HashSet<ContainerID>(containerIDs);
    }

    void removePipeline(PipelineID pipelineID) throws IOException {
        Preconditions.checkNotNull((Object)pipelineID, (Object)"Pipeline Id cannot be null");
        Set<ContainerID> containerIDs = this.getContainers(pipelineID);
        if (containerIDs.size() != 0) {
            throw new IOException(String.format("Pipeline with %s is not empty", pipelineID));
        }
        this.pipelineMap.remove(pipelineID);
        this.pipeline2container.remove(pipelineID);
    }

    void removeContainerFromPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        Preconditions.checkNotNull((Object)pipelineID, (Object)"Pipeline Id cannot be null");
        Preconditions.checkNotNull((Object)containerID, (Object)"container Id cannot be null");
        Pipeline pipeline = this.getPipeline(pipelineID);
        Set<ContainerID> containerIDs = this.pipeline2container.get(pipelineID);
        containerIDs.remove(containerID);
        if (containerIDs.size() == 0 && this.isClosingOrClosed(pipeline)) {
            this.removePipeline(pipelineID);
        }
    }

    Pipeline updatePipelineState(PipelineID pipelineID, HddsProtos.LifeCycleState state) throws IOException {
        Preconditions.checkNotNull((Object)pipelineID, (Object)"Pipeline Id cannot be null");
        Preconditions.checkNotNull((Object)state, (Object)"Pipeline LifeCycleState cannot be null");
        Pipeline pipeline = this.getPipeline(pipelineID);
        pipeline = this.pipelineMap.put(pipelineID, Pipeline.newBuilder((Pipeline)pipeline).setState(state).build());
        return pipeline;
    }

    private boolean isClosingOrClosed(Pipeline pipeline) {
        HddsProtos.LifeCycleState state = pipeline.getLifeCycleState();
        return state == HddsProtos.LifeCycleState.CLOSING || state == HddsProtos.LifeCycleState.CLOSED;
    }

    private boolean isOpen(Pipeline pipeline) {
        return pipeline.getLifeCycleState() == HddsProtos.LifeCycleState.OPEN;
    }
}

